/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.dialog;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.hop.core.Const;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variable;
import org.apache.hop.core.variables.VariableScope;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.FormDataBuilder;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.IDirectoryDialog;
import org.apache.hop.ui.core.dialog.IFileDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.dialog.NativeDirectoryDialog;
import org.apache.hop.ui.core.dialog.NativeFileDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.vfs.HopVfsFileDialog;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.HopGuiExtensionPoint;
import org.apache.hop.ui.hopgui.delegates.HopGuiDirectoryDialogExtension;
import org.apache.hop.ui.hopgui.delegates.HopGuiDirectorySelectedExtension;
import org.apache.hop.ui.hopgui.delegates.HopGuiFileDialogExtension;
import org.apache.hop.ui.hopgui.delegates.HopGuiFileOpenedExtension;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public abstract class BaseDialog
extends Dialog {
    private static final Class<?> PKG = BaseDialog.class;
    public static final String NO_DEFAULT_HANDLER = "NoDefaultHandler";
    @Variable(scope=VariableScope.APPLICATION, value="N", description="Set this value to 'Y' if you want to use the system file open/save dialog when browsing files.")
    public static final String HOP_USE_NATIVE_FILE_DIALOG = "HOP_USE_NATIVE_FILE_DIALOG";
    public static final int MARGIN_SIZE = 15;
    public static final int LABEL_SPACING = 5;
    public static final int ELEMENT_SPACING = 10;
    public static final int MEDIUM_FIELD = 250;
    public static final int MEDIUM_SMALL_FIELD = 150;
    public static final int SMALL_FIELD = 50;
    public static final int SHELL_WIDTH_OFFSET = 16;
    @Deprecated(since="2.10")
    public static final int VAR_ICON_WIDTH = GuiResource.getInstance().getImageVariableMini().getBounds().width;
    @Deprecated(since="2.10")
    public static final int VAR_ICON_HEIGHT = GuiResource.getInstance().getImageVariableMini().getBounds().height;
    protected Map<String, Listener> buttons = new HashMap<String, Listener>();
    protected Shell shell;
    protected PropsUi props = PropsUi.getInstance();
    protected int width;
    protected String baseDialogTitle;
    private int footerTopPadding = 40;

    protected BaseDialog(Shell shell) {
        this(shell, null, -1);
    }

    protected BaseDialog(Shell shell, String baseDialogTitle, int width) {
        super(shell, 0);
        this.baseDialogTitle = baseDialogTitle;
        this.width = width;
    }

    public static String presentFileDialog(Shell shell, String[] filterExtensions, String[] filterNames, boolean folderAndFile) {
        return BaseDialog.presentFileDialog(false, shell, null, null, null, filterExtensions, filterNames, folderAndFile);
    }

    public static String presentFileDialog(boolean save, Shell shell, String[] filterExtensions, String[] filterNames, boolean folderAndFile) {
        return BaseDialog.presentFileDialog(save, shell, null, null, null, filterExtensions, filterNames, folderAndFile);
    }

    @Deprecated(since="2.13")
    public static String presentFileDialog(Shell shell, TextVar textVar, FileObject fileObject, String[] filterExtensions, String[] filterNames, boolean folderAndFile) {
        return BaseDialog.presentFileDialog(false, shell, textVar, null, fileObject, filterExtensions, filterNames, folderAndFile);
    }

    public static String presentFileDialog(boolean save, Shell shell, TextVar textVar, FileObject fileObject, String[] filterExtensions, String[] filterNames, boolean folderAndFile) {
        return BaseDialog.presentFileDialog(save, shell, textVar, null, fileObject, filterExtensions, filterNames, folderAndFile);
    }

    public static String presentFileDialog(Shell shell, TextVar textVar, IVariables variables, String[] filterExtensions, String[] filterNames, boolean folderAndFile) {
        return BaseDialog.presentFileDialog(false, shell, textVar, variables, null, filterExtensions, filterNames, folderAndFile);
    }

    public static String presentFileDialog(boolean save, Shell shell, TextVar textVar, IVariables variables, String[] filterExtensions, String[] filterNames, boolean folderAndFile) {
        return BaseDialog.presentFileDialog(save, shell, textVar, variables, null, filterExtensions, filterNames, folderAndFile);
    }

    public static String presentFileDialog(Shell shell, TextVar textVar, IVariables variables, FileObject fileObject, String[] filterExtensions, String[] filterNames, boolean folderAndFile) {
        return BaseDialog.presentFileDialog(false, shell, textVar, variables, fileObject, filterExtensions, filterNames, folderAndFile);
    }

    public static String presentFileDialog(boolean save, Shell shell, TextVar textVar, IVariables variables, FileObject fileObject, String[] filterExtensions, String[] filterNames, boolean folderAndFile) {
        IFileDialog dialog;
        boolean useNativeFileDialog = HopGui.getInstance().getVariables().getVariableBoolean(HOP_USE_NATIVE_FILE_DIALOG, false);
        if (useNativeFileDialog) {
            FileDialog fileDialog = new FileDialog(shell, save ? 8192 : 4096);
            dialog = new NativeFileDialog(fileDialog);
        } else {
            HopVfsFileDialog vfsDialog = new HopVfsFileDialog(shell, variables, fileObject, false, save, folderAndFile);
            if (save) {
                if (textVar != null && !textVar.getText().isEmpty()) {
                    try {
                        fileObject = HopVfs.getFileObject((String)variables.resolve(textVar.getText()));
                        if (!fileObject.exists() && fileObject.getParent().exists()) {
                            fileObject = fileObject.getParent();
                        } else if (!fileObject.exists()) {
                            fileObject = null;
                        }
                        if (fileObject != null && fileObject.isFile()) {
                            vfsDialog.setSaveFilename(fileObject.getName().getBaseName());
                            vfsDialog.setFilterPath(HopVfs.getFilename((FileObject)fileObject));
                        } else if (filterExtensions != null && filterExtensions.length > 0) {
                            filterExtension = filterExtensions[0];
                            extension = filterExtension.substring(filterExtension.lastIndexOf("."));
                            vfsDialog.setSaveFilename("filename" + extension);
                        }
                    }
                    catch (Exception e) {
                        fileObject = null;
                    }
                } else if (filterExtensions != null && filterExtensions.length > 0) {
                    filterExtension = filterExtensions[0];
                    extension = filterExtension.substring(filterExtension.lastIndexOf("."));
                    vfsDialog.setSaveFilename("filename" + extension);
                }
            }
            dialog = vfsDialog;
        }
        if (save) {
            dialog.setText(BaseMessages.getString(PKG, (String)"BaseDialog.SaveFile", (String[])new String[0]));
        } else {
            dialog.setText(BaseMessages.getString(PKG, (String)"BaseDialog.OpenFile", (String[])new String[0]));
        }
        if (filterExtensions == null || filterNames == null || filterExtensions.length == 0 || filterNames.length == 0) {
            dialog.setFilterExtensions(new String[]{"*.*"});
            dialog.setFilterNames(new String[]{BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0])});
        } else {
            dialog.setFilterExtensions(filterExtensions);
            dialog.setFilterNames(filterNames);
        }
        AtomicBoolean doIt = new AtomicBoolean(true);
        try {
            ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.UI, (IVariables)variables, (String)HopGuiExtensionPoint.HopGuiFileOpenDialog.id, (Object)new HopGuiFileDialogExtension(doIt, dialog));
        }
        catch (Exception xe) {
            LogChannel.UI.logError("Error handling extension point 'HopGuiFileOpenDialog'", (Throwable)xe);
        }
        if (fileObject != null) {
            dialog.setFileName(HopVfs.getFilename((FileObject)fileObject));
            try {
                if (fileObject.isFile()) {
                    dialog.setFilterPath(HopVfs.getFilename((FileObject)fileObject.getParent()));
                } else {
                    dialog.setFilterPath(HopVfs.getFilename((FileObject)fileObject));
                }
            }
            catch (FileSystemException xe) {
                // empty catch block
            }
        }
        if (variables != null && textVar != null && textVar.getText() != null) {
            dialog.setFileName(variables.resolve(textVar.getText()));
        }
        String filename = null;
        if (!doIt.get() || dialog.open() != null) {
            filename = BaseDialog.buildFilename(dialog.getFilterPath(), dialog.getFileName());
            try {
                HopGuiFileOpenedExtension openedExtension = new HopGuiFileOpenedExtension(dialog, variables, filename);
                ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.UI, (IVariables)variables, (String)HopGuiExtensionPoint.HopGuiFileOpenedDialog.id, (Object)openedExtension);
                if (openedExtension.filename != null) {
                    filename = openedExtension.filename;
                }
            }
            catch (Exception xe) {
                LogChannel.UI.logError("Error handling extension point 'HopGuiFileOpenDialog'", (Throwable)xe);
            }
            if (textVar != null) {
                textVar.setText(filename);
            }
        }
        return filename;
    }

    private static String buildFilename(String filterPath, String fileName) {
        if (StringUtils.isEmpty((String)filterPath)) {
            return fileName;
        }
        if (filterPath.contains("://") || filterPath.contains(":///")) {
            fileName = fileName.replace(filterPath, "");
            if (filterPath.endsWith("/")) {
                return filterPath + fileName;
            }
            return filterPath + "/" + fileName;
        }
        return FilenameUtils.concat((String)filterPath, (String)fileName);
    }

    public static String presentDirectoryDialog(Shell shell) {
        return BaseDialog.presentDirectoryDialog(shell, null, null);
    }

    public static String presentDirectoryDialog(Shell shell, TextVar textVar, IVariables variables) {
        return BaseDialog.presentDirectoryDialog(shell, textVar, null, variables);
    }

    public static String presentDirectoryDialog(Shell shell, TextVar textVar, String message, IVariables variables) {
        String path = null;
        if (textVar != null && textVar.getText() != null) {
            path = textVar.getText();
        }
        String directory = BaseDialog.presentDirectoryDialog(shell, path, message, variables);
        if (textVar != null && directory != null) {
            textVar.setText(directory);
        }
        return directory;
    }

    public static String presentDirectoryDialog(Shell shell, String path, String message, IVariables variables) {
        boolean useNativeFileDialog = "Y".equalsIgnoreCase(HopGui.getInstance().getVariables().getVariable(HOP_USE_NATIVE_FILE_DIALOG, "N"));
        IDirectoryDialog directoryDialog = useNativeFileDialog ? new NativeDirectoryDialog(new DirectoryDialog(shell, 4096)) : new HopVfsFileDialog(shell, variables, null, true, false, true);
        if (StringUtils.isNotEmpty((String)message)) {
            directoryDialog.setMessage(message);
        }
        directoryDialog.setText(BaseMessages.getString(PKG, (String)"BaseDialog.OpenDirectory", (String[])new String[0]));
        if (variables != null && path != null) {
            directoryDialog.setFilterPath(variables.resolve(path));
        }
        String directoryName = null;
        AtomicBoolean doIt = new AtomicBoolean(true);
        try {
            ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.UI, (IVariables)variables, (String)HopGuiExtensionPoint.HopGuiFileDirectoryDialog.id, (Object)new HopGuiDirectoryDialogExtension(doIt, directoryDialog));
        }
        catch (Exception xe) {
            LogChannel.UI.logError("Error handling extension point 'HopGuiFileDirectoryDialog'", (Throwable)xe);
        }
        if (!doIt.get() || directoryDialog.open() != null) {
            directoryName = directoryDialog.getFilterPath();
            try {
                HopGuiDirectorySelectedExtension ext = new HopGuiDirectorySelectedExtension(directoryDialog, variables, directoryName);
                ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.UI, (IVariables)variables, (String)HopGuiExtensionPoint.HopGuiDirectorySelected.id, (Object)ext);
                if (ext.folderName != null) {
                    directoryName = ext.folderName;
                }
            }
            catch (Exception xe) {
                LogChannel.UI.logError("Error handling extension point 'HopGuiDirectorySelected'", (Throwable)xe);
            }
        }
        return directoryName;
    }

    private Display prepareLayout() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 268503136);
        this.shell.setImage(GuiResource.getInstance().getImageHopUi());
        PropsUi.setLook((Widget)this.shell);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                BaseDialog.this.dispose();
            }
        });
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(this.baseDialogTitle);
        return display;
    }

    protected abstract Control buildBody();

    public int open() {
        Display display = this.prepareLayout();
        Control lastBodyElement = this.buildBody();
        this.buildFooter(lastBodyElement);
        this.open(display);
        return 1;
    }

    private void open(Display display) {
        this.shell.pack();
        if (this.width > 0) {
            int height = this.shell.computeSize((int)this.width, (int)-1).y;
            this.shell.setMinimumSize(this.width + 16, height);
            this.shell.setSize(this.width + 16, height);
        }
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    protected void buildFooter(Control anchorElement) {
        Button button;
        Button[] buttonArr = new Button[this.buttons == null ? 0 : this.buttons.size()];
        int index = 0;
        if (this.buttons != null) {
            for (String buttonName : this.buttons.keySet()) {
                button = new Button((Composite)this.shell, 8);
                button.setText(buttonName);
                Listener listener = this.buttons.get(buttonName);
                if (listener != null) {
                    button.addListener(13, listener);
                } else {
                    button.addListener(13, event -> this.dispose());
                }
                buttonArr[index++] = button;
            }
        }
        Button previousButton = null;
        for (int i = buttonArr.length - 1; i >= 0; --i) {
            button = buttonArr[i];
            if (previousButton == null) {
                button.setLayoutData((Object)new FormDataBuilder().top(anchorElement, this.footerTopPadding).right(100, 0).result());
            } else {
                button.setLayoutData((Object)new FormDataBuilder().top(anchorElement, this.footerTopPadding).right((Control)previousButton, Const.isOSX() ? 0 : -5).result());
            }
            previousButton = button;
        }
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public static void defaultShellHandling(Shell shell, Consumer<Void> okConsumer, Consumer<Void> cancelConsumer) {
        BaseDialog.defaultShellHandling(shell, okConsumer, () -> {
            cancelConsumer.accept(null);
            return true;
        });
    }

    public static void defaultShellHandling(Shell shell, Consumer<Void> okConsumer, Supplier<Boolean> cancelSupplier) {
        shell.addListener(21, e -> {
            e.doit = (Boolean)cancelSupplier.get();
        });
        BaseDialog.addDefaultListeners((Composite)shell, okConsumer);
        BaseDialog.addSpacesOnTabs((Composite)shell);
        BaseTransformDialog.setSize(shell);
        shell.open();
        Display display = shell.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public static void addSpacesOnTabs(Composite composite) {
        if (composite == null || composite.isDisposed()) {
            return;
        }
        for (Control control : composite.getChildren()) {
            if (!(control instanceof CTabFolder)) continue;
            CTabFolder cTabFolder = (CTabFolder)control;
            for (CTabItem item : cTabFolder.getItems()) {
                if (item.getText() == null) continue;
                item.setText("  " + item.getText() + "  ");
            }
        }
    }

    public static void addDefaultListeners(Composite composite, Consumer<Void> okConsumer) {
        if (composite == null || composite.isDisposed()) {
            return;
        }
        for (Control control : composite.getChildren()) {
            if (control.getData(NO_DEFAULT_HANDLER) != null) continue;
            if (control instanceof Text || control instanceof Combo || control instanceof CCombo || control instanceof TextVar || control instanceof ComboVar || control instanceof List) {
                control.addListener(14, e -> okConsumer.accept(null));
                continue;
            }
            if (!(control instanceof Composite)) continue;
            Composite composite1 = (Composite)control;
            BaseDialog.addDefaultListeners(composite1, okConsumer);
        }
    }

    public static int openMessageBox(Shell parent, String title, String message, int flags) {
        MessageBox box = new MessageBox(parent, flags);
        box.setText(title);
        box.setMessage(message);
        return box.open();
    }

    @Generated
    public void setButtons(Map<String, Listener> buttons) {
        this.buttons = buttons;
    }

    @Generated
    public void setFooterTopPadding(int footerTopPadding) {
        this.footerTopPadding = footerTopPadding;
    }
}

