/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.debug.transform;

import org.apache.hop.core.Condition;
import org.apache.hop.core.logging.LogLevel;

public class TransformDebugLevel
implements Cloneable {
    private LogLevel logLevel;
    private int startRow = -1;
    private int endRow = -1;
    private Condition condition = new Condition();

    public TransformDebugLevel() {
        this.logLevel = LogLevel.DEBUG;
    }

    public TransformDebugLevel(LogLevel logLevel) {
        this();
        this.logLevel = logLevel;
    }

    public TransformDebugLevel(LogLevel logLevel, int startRow, int endRow, Condition condition) {
        this(logLevel);
        this.startRow = startRow;
        this.endRow = endRow;
        this.condition = condition;
    }

    public String toString() {
        Object s = this.logLevel.toString();
        if (this.startRow >= 0) {
            s = (String)s + ", start row=" + this.startRow;
        }
        if (this.endRow >= 0) {
            s = (String)s + ", end row=" + this.endRow;
        }
        if (this.condition != null && !this.condition.isEmpty()) {
            s = (String)s + ", condition=" + this.condition.toString();
        }
        return s;
    }

    public TransformDebugLevel clone() {
        return new TransformDebugLevel(this.logLevel, this.startRow, this.endRow, this.condition.clone());
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    public int getEndRow() {
        return this.endRow;
    }

    public void setEndRow(int endRow) {
        this.endRow = endRow;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }
}

