/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class AbstractAutoCloseableRegistry<R extends AutoCloseable, C extends R, T, E extends Exception>
implements AutoCloseable {
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    protected final Map<R, T> closeableToRef;
    @GuardedBy(value="lock")
    private boolean closed;

    public AbstractAutoCloseableRegistry(@Nonnull Map<R, T> closeableToRef) {
        this.closeableToRef = Preconditions.checkNotNull(closeableToRef);
        this.closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerCloseable(C closeable) throws IOException {
        if (null == closeable) {
            return;
        }
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            if (!this.closed) {
                this.doRegister(closeable, this.closeableToRef);
                return;
            }
        }
        IOUtils.closeQuietly(closeable);
        throw new IOException("Cannot register Closeable, registry is already closed. Closing argument.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean unregisterCloseable(C closeable) {
        if (null == closeable) {
            return false;
        }
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            return this.doUnRegister(closeable, this.closeableToRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws E {
        ArrayList<R> toCloseCopy;
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            toCloseCopy = new ArrayList<R>(this.closeableToRef.keySet());
            this.closeableToRef.clear();
        }
        this.doClose(toCloseCopy);
    }

    protected abstract void doClose(List<R> var1) throws E;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            return this.closed;
        }
    }

    protected abstract void doRegister(@Nonnull C var1, @Nonnull Map<R, T> var2);

    protected abstract boolean doUnRegister(@Nonnull C var1, @Nonnull Map<R, T> var2);

    protected final Object getSynchronizationLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean removeCloseableInternal(R closeable) {
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            return this.closeableToRef.remove(closeable) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final int getNumberOfRegisteredCloseables() {
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            return this.closeableToRef.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final boolean isCloseableRegistered(R c) {
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            return this.closeableToRef.containsKey(c);
        }
    }
}

