/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerUtil;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.runtime.PojoSerializer;
import org.apache.flink.api.java.typeutils.runtime.PojoSerializerSnapshotData;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.LinkedOptionalMap;
import org.apache.flink.util.Preconditions;

@Internal
public class PojoSerializerSnapshot<T>
implements TypeSerializerSnapshot<T> {
    private static final int VERSION = 2;
    private PojoSerializerSnapshotData<T> snapshotData;
    private SerializerConfig serializerConfig;

    public PojoSerializerSnapshot() {
    }

    PojoSerializerSnapshot(Class<T> pojoClass, Field[] fields, TypeSerializer<?>[] fieldSerializers, LinkedHashMap<Class<?>, TypeSerializer<?>> registeredSubclassSerializers, Map<Class<?>, TypeSerializer<?>> nonRegisteredSubclassSerializers, SerializerConfig serializerConfig) {
        this.snapshotData = PojoSerializerSnapshotData.createFrom(pojoClass, fields, fieldSerializers, registeredSubclassSerializers, nonRegisteredSubclassSerializers);
        this.serializerConfig = serializerConfig;
    }

    PojoSerializerSnapshot(Class<T> pojoClass, Field[] fields, TypeSerializerSnapshot<?>[] existingFieldSerializerSnapshots, LinkedHashMap<Class<?>, TypeSerializerSnapshot<?>> existingRegisteredSubclassSerializerSnapshots, Map<Class<?>, TypeSerializerSnapshot<?>> existingNonRegisteredSubclassSerializerSnapshots, SerializerConfig serializerConfig) {
        this.snapshotData = PojoSerializerSnapshotData.createFrom(pojoClass, fields, existingFieldSerializerSnapshots, existingRegisteredSubclassSerializerSnapshots, existingNonRegisteredSubclassSerializerSnapshots);
        this.serializerConfig = serializerConfig;
    }

    @Override
    public int getCurrentVersion() {
        return 2;
    }

    @Override
    public void writeSnapshot(DataOutputView out) throws IOException {
        this.snapshotData.writeSnapshotData(out);
    }

    @Override
    public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        Preconditions.checkArgument(readVersion == 2, "unrecognized read version %s", readVersion);
        this.snapshotData = PojoSerializerSnapshotData.createFrom(in, userCodeClassLoader);
    }

    @Override
    public TypeSerializer<T> restoreSerializer() {
        int numFields = this.snapshotData.getFieldSerializerSnapshots().size();
        ArrayList restoredFields = new ArrayList(numFields);
        ArrayList restoredFieldSerializers = new ArrayList(numFields);
        this.snapshotData.getFieldSerializerSnapshots().forEach((fieldName, field, fieldSerializerSnapshot) -> {
            restoredFields.add(field);
            Preconditions.checkState(fieldSerializerSnapshot != null, "field serializer snapshots should be present.");
            restoredFieldSerializers.add(fieldSerializerSnapshot.restoreSerializer());
        });
        LinkedHashMap<Class<?>, TypeSerializer<?>> registeredSubclassSerializers = PojoSerializerSnapshot.restoreSerializers(this.snapshotData.getRegisteredSubclassSerializerSnapshots().unwrapOptionals());
        Tuple2<LinkedHashMap<Class<?>, Integer>, TypeSerializer<Object>[]> decomposedSubclassSerializerRegistry = PojoSerializerSnapshot.decomposeSubclassSerializerRegistry(registeredSubclassSerializers);
        LinkedHashMap<Class<?>, TypeSerializer<?>> nonRegisteredSubclassSerializers = PojoSerializerSnapshot.restoreSerializers(this.snapshotData.getNonRegisteredSubclassSerializerSnapshots().unwrapOptionals());
        return new PojoSerializer<T>(this.snapshotData.getPojoClass(), restoredFields.toArray(new Field[numFields]), restoredFieldSerializers.toArray(new TypeSerializer[numFields]), (LinkedHashMap)decomposedSubclassSerializerRegistry.f0, (TypeSerializer[])decomposedSubclassSerializerRegistry.f1, nonRegisteredSubclassSerializers, new SerializerConfigImpl());
    }

    @Override
    public TypeSerializerSchemaCompatibility<T> resolveSchemaCompatibility(TypeSerializerSnapshot<T> oldSerializerSnapshot) {
        if (!(oldSerializerSnapshot instanceof PojoSerializerSnapshot)) {
            return TypeSerializerSchemaCompatibility.incompatible();
        }
        PojoSerializerSnapshot previousPojoSerializerSnapshot = (PojoSerializerSnapshot)oldSerializerSnapshot;
        Class<T> previousPojoClass = previousPojoSerializerSnapshot.snapshotData.getPojoClass();
        LinkedOptionalMap<Field, TypeSerializerSnapshot<?>> fieldSerializerSnapshots = previousPojoSerializerSnapshot.snapshotData.getFieldSerializerSnapshots();
        LinkedOptionalMap<Class<?>, TypeSerializerSnapshot<?>> registeredSubclassSerializerSnapshots = previousPojoSerializerSnapshot.snapshotData.getRegisteredSubclassSerializerSnapshots();
        LinkedOptionalMap<Class<?>, TypeSerializerSnapshot<?>> nonRegisteredSubclassSerializerSnapshots = previousPojoSerializerSnapshot.snapshotData.getNonRegisteredSubclassSerializerSnapshots();
        if (previousPojoClass != this.snapshotData.getPojoClass()) {
            return TypeSerializerSchemaCompatibility.incompatible();
        }
        if (registeredSubclassSerializerSnapshots.hasAbsentKeysOrValues()) {
            return TypeSerializerSchemaCompatibility.incompatible();
        }
        if (nonRegisteredSubclassSerializerSnapshots.hasAbsentKeysOrValues()) {
            return TypeSerializerSchemaCompatibility.incompatible();
        }
        CompositeTypeSerializerUtil.IntermediateCompatibilityResult<T> preExistingFieldSerializersCompatibility = this.getCompatibilityOfPreExistingFields(fieldSerializerSnapshots);
        if (preExistingFieldSerializersCompatibility.isIncompatible()) {
            return TypeSerializerSchemaCompatibility.incompatible();
        }
        CompositeTypeSerializerUtil.IntermediateCompatibilityResult<T> preExistingRegistrationsCompatibility = this.getCompatibilityOfPreExistingRegisteredSubclasses(registeredSubclassSerializerSnapshots);
        if (preExistingRegistrationsCompatibility.isIncompatible()) {
            return TypeSerializerSchemaCompatibility.incompatible();
        }
        if (this.newPojoSerializerIsCompatibleAfterMigration(preExistingFieldSerializersCompatibility, preExistingRegistrationsCompatibility, fieldSerializerSnapshots)) {
            return TypeSerializerSchemaCompatibility.compatibleAfterMigration();
        }
        if (this.newPojoSerializerIsCompatibleWithReconfiguredSerializer(preExistingFieldSerializersCompatibility, preExistingRegistrationsCompatibility, registeredSubclassSerializerSnapshots, nonRegisteredSubclassSerializerSnapshots)) {
            return TypeSerializerSchemaCompatibility.compatibleWithReconfiguredSerializer(this.constructReconfiguredPojoSerializer(preExistingFieldSerializersCompatibility, registeredSubclassSerializerSnapshots, preExistingRegistrationsCompatibility, nonRegisteredSubclassSerializerSnapshots));
        }
        return TypeSerializerSchemaCompatibility.compatibleAsIs();
    }

    private static <K> LinkedHashMap<K, TypeSerializer<?>> restoreSerializers(LinkedHashMap<K, TypeSerializerSnapshot<?>> snapshotsMap) {
        LinkedHashMap restoredSerializersMap = CollectionUtil.newLinkedHashMapWithExpectedSize(snapshotsMap.size());
        snapshotsMap.forEach((key, snapshot) -> restoredSerializersMap.put(key, snapshot.restoreSerializer()));
        return restoredSerializersMap;
    }

    private static Tuple2<LinkedHashMap<Class<?>, Integer>, TypeSerializer<Object>[]> decomposeSubclassSerializerRegistry(LinkedHashMap<Class<?>, TypeSerializer<?>> subclassSerializerRegistry) {
        LinkedHashMap subclassIds = CollectionUtil.newLinkedHashMapWithExpectedSize(subclassSerializerRegistry.size());
        TypeSerializer[] subclassSerializers = new TypeSerializer[subclassSerializerRegistry.size()];
        subclassSerializerRegistry.forEach((registeredSubclassClass, serializer) -> {
            int id = subclassIds.size();
            subclassIds.put(registeredSubclassClass, id);
            subclassSerializers[id] = serializer;
        });
        return Tuple2.of(subclassIds, subclassSerializers);
    }

    private CompositeTypeSerializerUtil.IntermediateCompatibilityResult<T> getCompatibilityOfPreExistingFields(LinkedOptionalMap<Field, TypeSerializerSnapshot<?>> oldFieldSerializerSnapshots) {
        Set<LinkedOptionalMap.KeyValue<Field, TypeSerializerSnapshot<?>>> presentFieldSnapshots = oldFieldSerializerSnapshots.getPresentEntries();
        ArrayList associatedFieldSerializerSnapshots = new ArrayList(presentFieldSnapshots.size());
        ArrayList<TypeSerializerSnapshot> associatedNewFieldSerializerSnapshots = new ArrayList<TypeSerializerSnapshot>(presentFieldSnapshots.size());
        LinkedHashMap<Field, TypeSerializerSnapshot<?>> newFieldSerializerSnapshots = this.snapshotData.getFieldSerializerSnapshots().unwrapOptionals();
        for (LinkedOptionalMap.KeyValue<Field, TypeSerializerSnapshot<?>> presentFieldEntry : presentFieldSnapshots) {
            TypeSerializerSnapshot associatedNewFieldSerializer = (TypeSerializerSnapshot)newFieldSerializerSnapshots.get(presentFieldEntry.getKey());
            Preconditions.checkState(associatedNewFieldSerializer != null, "a present field should have its associated new field serializer available.");
            associatedFieldSerializerSnapshots.add(presentFieldEntry.getValue());
            associatedNewFieldSerializerSnapshots.add(associatedNewFieldSerializer);
        }
        return CompositeTypeSerializerUtil.constructIntermediateCompatibilityResult(associatedNewFieldSerializerSnapshots.toArray(new TypeSerializerSnapshot[associatedNewFieldSerializerSnapshots.size()]), associatedFieldSerializerSnapshots.toArray(new TypeSerializerSnapshot[associatedFieldSerializerSnapshots.size()]));
    }

    private CompositeTypeSerializerUtil.IntermediateCompatibilityResult<T> getCompatibilityOfPreExistingRegisteredSubclasses(LinkedOptionalMap<Class<?>, TypeSerializerSnapshot<?>> registeredSubclassSerializerSnapshots) {
        LinkedHashMap<Class<?>, TypeSerializerSnapshot<?>> unwrappedSerializerSnapshots = registeredSubclassSerializerSnapshots.unwrapOptionals();
        ArrayList associatedSubclassSerializerSnapshots = new ArrayList();
        ArrayList associatedNewSubclassSerializerSnapshots = new ArrayList();
        LinkedHashMap<Class<?>, TypeSerializerSnapshot<?>> newSubclassSerializerRegistry = this.snapshotData.getRegisteredSubclassSerializerSnapshots().unwrapOptionals();
        for (Map.Entry<Class<?>, TypeSerializerSnapshot<?>> entry : unwrappedSerializerSnapshots.entrySet()) {
            TypeSerializerSnapshot<?> newRegisteredSerializerSnapshot = newSubclassSerializerRegistry.get(entry.getKey());
            if (newRegisteredSerializerSnapshot == null) continue;
            associatedSubclassSerializerSnapshots.add(entry.getValue());
            associatedNewSubclassSerializerSnapshots.add(newRegisteredSerializerSnapshot);
        }
        return CompositeTypeSerializerUtil.constructIntermediateCompatibilityResult(associatedNewSubclassSerializerSnapshots.toArray(new TypeSerializerSnapshot[associatedNewSubclassSerializerSnapshots.size()]), associatedSubclassSerializerSnapshots.toArray(new TypeSerializerSnapshot[associatedSubclassSerializerSnapshots.size()]));
    }

    private boolean newPojoSerializerIsCompatibleAfterMigration(CompositeTypeSerializerUtil.IntermediateCompatibilityResult<T> fieldSerializerCompatibility, CompositeTypeSerializerUtil.IntermediateCompatibilityResult<T> preExistingRegistrationsCompatibility, LinkedOptionalMap<Field, TypeSerializerSnapshot<?>> fieldSerializerSnapshots) {
        return this.newPojoHasNewOrRemovedFields(fieldSerializerSnapshots) || fieldSerializerCompatibility.isCompatibleAfterMigration() || preExistingRegistrationsCompatibility.isCompatibleAfterMigration();
    }

    private boolean newPojoSerializerIsCompatibleWithReconfiguredSerializer(CompositeTypeSerializerUtil.IntermediateCompatibilityResult<T> fieldSerializerCompatibility, CompositeTypeSerializerUtil.IntermediateCompatibilityResult<T> preExistingRegistrationsCompatibility, LinkedOptionalMap<Class<?>, TypeSerializerSnapshot<?>> registeredSubclassSerializerSnapshots, LinkedOptionalMap<Class<?>, TypeSerializerSnapshot<?>> nonRegisteredSubclassSerializerSnapshots) {
        return this.newPojoHasDifferentSubclassRegistrationOrder(registeredSubclassSerializerSnapshots) || PojoSerializerSnapshot.previousSerializerHasNonRegisteredSubclasses(nonRegisteredSubclassSerializerSnapshots) || fieldSerializerCompatibility.isCompatibleWithReconfiguredSerializer() || preExistingRegistrationsCompatibility.isCompatibleWithReconfiguredSerializer();
    }

    private boolean newPojoHasNewOrRemovedFields(LinkedOptionalMap<Field, TypeSerializerSnapshot<?>> fieldSerializerSnapshots) {
        int numRemovedFields = fieldSerializerSnapshots.absentKeysOrValues().size();
        int numPreexistingFields = fieldSerializerSnapshots.size() - numRemovedFields;
        boolean hasRemovedFields = numRemovedFields > 0;
        boolean hasNewFields = this.snapshotData.getFieldSerializerSnapshots().size() - numPreexistingFields > 0;
        return hasRemovedFields || hasNewFields;
    }

    private boolean newPojoHasDifferentSubclassRegistrationOrder(LinkedOptionalMap<Class<?>, TypeSerializerSnapshot<?>> registeredSubclassSerializerSnapshots) {
        Set<Class<?>> newRegistrationOrder;
        Set<Class<?>> previousRegistrationOrder = registeredSubclassSerializerSnapshots.unwrapOptionals().keySet();
        return !PojoSerializerSnapshot.isPreviousRegistrationPrefixOfNewRegistration(previousRegistrationOrder, newRegistrationOrder = this.snapshotData.getRegisteredSubclassSerializerSnapshots().unwrapOptionals().keySet());
    }

    private static boolean isPreviousRegistrationPrefixOfNewRegistration(Set<Class<?>> previousRegistrationOrder, Set<Class<?>> newRegistrationOrder) {
        Iterator<Class<?>> newRegistrationItr = newRegistrationOrder.iterator();
        for (Class<?> previousRegisteredClass : previousRegistrationOrder) {
            if (!newRegistrationItr.hasNext()) {
                return false;
            }
            Class<?> newRegisteredClass = newRegistrationItr.next();
            if (previousRegisteredClass.equals(newRegisteredClass)) continue;
            return false;
        }
        return true;
    }

    private static boolean previousSerializerHasNonRegisteredSubclasses(LinkedOptionalMap<Class<?>, TypeSerializerSnapshot<?>> nonRegisteredSubclassSerializerSnapshots) {
        return nonRegisteredSubclassSerializerSnapshots.size() > 0;
    }

    private PojoSerializer<T> constructReconfiguredPojoSerializer(CompositeTypeSerializerUtil.IntermediateCompatibilityResult<T> fieldSerializerCompatibility, LinkedOptionalMap<Class<?>, TypeSerializerSnapshot<?>> registeredSerializerSnapshots, CompositeTypeSerializerUtil.IntermediateCompatibilityResult<T> preExistingRegistrationsCompatibility, LinkedOptionalMap<Class<?>, TypeSerializerSnapshot<?>> nonRegisteredSubclassSerializerSnapshots) {
        TypeSerializer[] reconfiguredFieldSerializers = PojoSerializerSnapshot.constructReconfiguredFieldSerializers(fieldSerializerCompatibility);
        Tuple2<LinkedHashMap<Class<?>, Integer>, TypeSerializer<Object>[]> reconfiguredSubclassRegistry = PojoSerializerSnapshot.constructReconfiguredSubclassRegistrations(this.snapshotData.getRegisteredSubclassSerializerSnapshots().unwrapOptionals(), registeredSerializerSnapshots, preExistingRegistrationsCompatibility);
        return new PojoSerializer<T>(this.snapshotData.getPojoClass(), this.snapshotData.getFieldSerializerSnapshots().unwrapOptionals().keySet().toArray(new Field[0]), reconfiguredFieldSerializers, (LinkedHashMap)reconfiguredSubclassRegistry.f0, (TypeSerializer[])reconfiguredSubclassRegistry.f1, PojoSerializerSnapshot.restoreSerializers(nonRegisteredSubclassSerializerSnapshots.unwrapOptionals()), this.serializerConfig);
    }

    private static TypeSerializer[] constructReconfiguredFieldSerializers(CompositeTypeSerializerUtil.IntermediateCompatibilityResult<?> fieldSerializerCompatibility) {
        Preconditions.checkArgument(!fieldSerializerCompatibility.isIncompatible() && !fieldSerializerCompatibility.isCompatibleAfterMigration());
        return fieldSerializerCompatibility.getNestedSerializers();
    }

    private static Tuple2<LinkedHashMap<Class<?>, Integer>, TypeSerializer<Object>[]> constructReconfiguredSubclassRegistrations(LinkedHashMap<Class<?>, TypeSerializerSnapshot<?>> newSubclassRegistrations, LinkedOptionalMap<Class<?>, TypeSerializerSnapshot<?>> oldRegisteredSerializerSnapshots, CompositeTypeSerializerUtil.IntermediateCompatibilityResult<?> preExistingRegistrationsCompatibility) {
        Preconditions.checkArgument(!preExistingRegistrationsCompatibility.isIncompatible() && !preExistingRegistrationsCompatibility.isCompatibleAfterMigration());
        LinkedHashMap<Class<?>, TypeSerializer<?>> reconfiguredSubclassSerializerRegistry = PojoSerializerSnapshot.restoreSerializers(oldRegisteredSerializerSnapshots.unwrapOptionals());
        Iterator<TypeSerializer<?>> serializersForPreexistingRegistrations = Arrays.asList(preExistingRegistrationsCompatibility.getNestedSerializers()).iterator();
        for (Map.Entry<Class<?>, TypeSerializer<?>> entry : reconfiguredSubclassSerializerRegistry.entrySet()) {
            if (!newSubclassRegistrations.containsKey(entry.getKey())) continue;
            entry.setValue(serializersForPreexistingRegistrations.next());
        }
        for (Map.Entry<Class<?>, Object> entry : newSubclassRegistrations.entrySet()) {
            TypeSerializer<?> oldRegistration = reconfiguredSubclassSerializerRegistry.get(entry.getKey());
            if (oldRegistration != null) continue;
            reconfiguredSubclassSerializerRegistry.put(entry.getKey(), ((TypeSerializerSnapshot)entry.getValue()).restoreSerializer());
        }
        return PojoSerializerSnapshot.decomposeSubclassSerializerRegistry(reconfiguredSubclassSerializerRegistry);
    }
}

