/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.triggers;

import io.github.spannm.jackcess.Column;
import io.github.spannm.jackcess.DataType;
import io.github.spannm.jackcess.Table;
import io.github.spannm.jackcess.complex.ComplexDataType;
import io.github.spannm.jackcess.impl.ColumnImpl;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.UUID;
import net.ucanaccess.complex.Attachment;
import net.ucanaccess.complex.SingleValue;
import net.ucanaccess.exception.TableNotFoundException;
import net.ucanaccess.exception.UcanaccessRuntimeException;
import net.ucanaccess.jdbc.UcanaccessConnection;
import net.ucanaccess.triggers.AutoNumberManager;
import net.ucanaccess.triggers.TriggerBase;
import net.ucanaccess.triggers.TriggerException;
import org.hsqldb.types.JavaObjectData;

public class TriggerAutoNumber
extends TriggerBase {
    private static final String GUID_PATTERN = "\\s*[{]?([\\p{XDigit}]{8})-([\\p{XDigit}]{4})-([\\p{XDigit}]{4})-([\\p{XDigit}]{4})-([\\p{XDigit}]{12})[}]?\\s*";

    public void fire(int type, String name, String tableName, Object[] oldR, Object[] newR) {
        this.checkContext();
        UcanaccessConnection conn = UcanaccessConnection.getCtxConnection();
        if (conn.isFeedbackState()) {
            return;
        }
        try {
            Table t = this.getTable(tableName, conn);
            if (t == null) {
                throw new TableNotFoundException(tableName);
            }
            int i = 0;
            for (Column cli : t.getColumns()) {
                ColumnImpl cl = (ColumnImpl)cli;
                if (cli.getType().equals((Object)DataType.COMPLEX_TYPE) && (newR[i] == null || "".equals(newR[i]))) {
                    if (cli.getComplexInfo().getType().equals((Object)ComplexDataType.ATTACHMENT)) {
                        newR[i] = new JavaObjectData((Serializable)new Attachment[0]);
                    } else if (cli.getComplexInfo().getType().equals((Object)ComplexDataType.MULTI_VALUE)) {
                        newR[i] = new JavaObjectData((Serializable)new SingleValue[0]);
                    }
                } else if (cl.isAutoNumber()) {
                    if (6 == type) {
                        if (t.isAllowAutoNumberInsert()) {
                            if (cl.getAutoNumberGenerator().getType().equals((Object)DataType.LONG) && newR[i] != null) {
                                AutoNumberManager.bump((Column)cl, (Integer)newR[i]);
                            }
                        } else if (cl.getAutoNumberGenerator().getType().equals((Object)DataType.GUID)) {
                            if (newR[i] == null) {
                                newR[i] = "{" + UUID.randomUUID().toString().toUpperCase() + "}";
                            }
                            conn.setGeneratedKey(newR[i]);
                        } else if (cl.getAutoNumberGenerator().getType().equals((Object)DataType.LONG)) {
                            int keyg = AutoNumberManager.getNext((Column)cl);
                            newR[i] = keyg;
                            conn.setGeneratedKey(newR[i]);
                        }
                    } else if (8 == type && cl.getAutoNumberGenerator().getType().equals((Object)DataType.LONG)) {
                        if (!oldR[i].equals(newR[i])) {
                            throw new UcanaccessRuntimeException("Cannot update autoincrement column");
                        }
                    } else if (cl.getAutoNumberGenerator().getType().equals((Object)DataType.GUID)) {
                        this.validateGUID(newR[i]);
                    }
                } else if (DataType.BOOLEAN.equals((Object)cl.getType()) && newR[i] == null) {
                    newR[i] = false;
                }
                ++i;
            }
        }
        catch (Exception _ex) {
            throw new TriggerException(_ex.getMessage());
        }
    }

    private void validateGUID(Object guid) throws SQLException {
        String guidS;
        if (guid instanceof String && ((guidS = (String)guid).length() != 38 || !guidS.matches(GUID_PATTERN))) {
            throw new SQLException("Invalid guid format " + guidS);
        }
    }
}

