/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.RowFilter;
import com.google.bigtable.v2.RowRange;
import com.google.bigtable.v2.RowSet;
import com.google.cloud.bigtable.data.v2.internal.ByteStringComparator;
import com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.internal.RowSetUtil;
import com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.cloud.bigtable.data.v2.models.KeyOffset;
import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.cloud.bigtable.data.v2.models.TableId;
import com.google.cloud.bigtable.data.v2.models.TargetId;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import javax.annotation.Nonnull;

public final class Query
implements Serializable {
    private static final long serialVersionUID = -316972783499434755L;
    private static final int MAX_FILTER_SIZE = 20480;
    private final TargetId targetId;
    private transient ReadRowsRequest.Builder builder = ReadRowsRequest.newBuilder();

    @Deprecated
    public static Query create(String tableId) {
        return new Query(TableId.of(tableId));
    }

    public static Query create(TargetId targetId) {
        return new Query(targetId);
    }

    private Query(TargetId targetId) {
        Preconditions.checkNotNull((Object)targetId, (Object)"target id can't be null.");
        this.targetId = targetId;
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.builder = (ReadRowsRequest.Builder)ReadRowsRequest.newBuilder().mergeFrom((InputStream)input);
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
        this.builder.build().writeTo((OutputStream)output);
    }

    public Query rowKey(String key) {
        Preconditions.checkNotNull((Object)key, (Object)"Key can't be null.");
        return this.rowKey(ByteString.copyFromUtf8((String)key));
    }

    public Query rowKey(ByteString key) {
        Preconditions.checkNotNull((Object)key, (Object)"Key can't be null.");
        this.builder.getRowsBuilder().addRowKeys(key);
        return this;
    }

    public Query prefix(ByteString prefix) {
        return this.range(Range.ByteStringRange.prefix(prefix));
    }

    public Query prefix(String prefix) {
        return this.range(Range.ByteStringRange.prefix(prefix));
    }

    public Query range(String start, String end) {
        return this.range(Query.wrapKey(start), Query.wrapKey(end));
    }

    public Query range(ByteString start, ByteString end) {
        RowRange.Builder rangeBuilder = RowRange.newBuilder();
        if (start != null) {
            rangeBuilder.setStartKeyClosed(start);
        }
        if (end != null) {
            rangeBuilder.setEndKeyOpen(end);
        }
        this.builder.getRowsBuilder().addRowRanges(rangeBuilder.build());
        return this;
    }

    public Query range(Range.ByteStringRange range) {
        RowRange.Builder rangeBuilder = RowRange.newBuilder();
        switch (range.getStartBound()) {
            case OPEN: {
                rangeBuilder.setStartKeyOpen((ByteString)range.getStart());
                break;
            }
            case CLOSED: {
                rangeBuilder.setStartKeyClosed((ByteString)range.getStart());
                break;
            }
            case UNBOUNDED: {
                rangeBuilder.clearStartKey();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown start bound: " + (Object)((Object)range.getStartBound()));
            }
        }
        switch (range.getEndBound()) {
            case OPEN: {
                rangeBuilder.setEndKeyOpen((ByteString)range.getEnd());
                break;
            }
            case CLOSED: {
                rangeBuilder.setEndKeyClosed((ByteString)range.getEnd());
                break;
            }
            case UNBOUNDED: {
                rangeBuilder.clearEndKey();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown end bound: " + (Object)((Object)range.getEndBound()));
            }
        }
        this.builder.getRowsBuilder().addRowRanges(rangeBuilder.build());
        return this;
    }

    public Query filter(Filters.Filter filter) {
        Preconditions.checkNotNull((Object)filter, (Object)"filter can't be null");
        RowFilter rowFilter = filter.toProto();
        Preconditions.checkArgument((rowFilter.getSerializedSize() < 20480 ? 1 : 0) != 0, (Object)"filter size can't be more than 20KB");
        this.builder.setFilter(rowFilter);
        return this;
    }

    public Query limit(long limit) {
        Preconditions.checkArgument((limit > 0L ? 1 : 0) != 0, (Object)"Limit must be greater than 0.");
        this.builder.setRowsLimit(limit);
        return this;
    }

    public Query reversed(boolean enable) {
        this.builder.setReversed(enable);
        return this;
    }

    public List<Query> shard(List<KeyOffset> sampledRowKeys) {
        Preconditions.checkState((this.builder.getRowsLimit() == 0L ? 1 : 0) != 0, (Object)"Can't shard query with row limits");
        ImmutableSortedSet.Builder splitPoints = ImmutableSortedSet.orderedBy((Comparator)ByteStringComparator.INSTANCE);
        for (KeyOffset keyOffset : sampledRowKeys) {
            if (keyOffset.getKey().isEmpty()) continue;
            splitPoints.add((Object)keyOffset.getKey());
        }
        return this.shard((SortedSet<ByteString>)splitPoints.build());
    }

    public List<Query> shard(SortedSet<ByteString> splitPoints) {
        Preconditions.checkState((this.builder.getRowsLimit() == 0L ? 1 : 0) != 0, (Object)"Can't shard a query with a row limit");
        List<RowSet> shardedRowSets = RowSetUtil.shard(this.builder.getRows(), splitPoints);
        ArrayList shards = Lists.newArrayListWithCapacity((int)shardedRowSets.size());
        for (RowSet rowSet : shardedRowSets) {
            Query queryShard = new Query(this.targetId);
            queryShard.builder.mergeFrom(this.builder.build());
            queryShard.builder.setRows(rowSet);
            shards.add(queryShard);
        }
        return shards;
    }

    @BetaApi(value="This surface is stable yet it might be removed in the future.")
    public QueryPaginator createPaginator(int pageSize) {
        return new QueryPaginator(this, pageSize);
    }

    public Range.ByteStringRange getBound() {
        return RowSetUtil.getBound(this.builder.getRows());
    }

    @InternalApi
    public ReadRowsRequest toProto(RequestContext requestContext) {
        String resourceName = this.targetId.toResourceName(requestContext.getProjectId(), requestContext.getInstanceId());
        if (this.targetId.scopedForAuthorizedView()) {
            this.builder.setAuthorizedViewName(resourceName);
        } else {
            this.builder.setTableName(resourceName);
        }
        return this.builder.setAppProfileId(requestContext.getAppProfileId()).build();
    }

    public static Query fromProto(@Nonnull ReadRowsRequest request) {
        Preconditions.checkArgument((request != null ? 1 : 0) != 0, (Object)"ReadRowsRequest must not be null");
        String tableName = request.getTableName();
        String authorizedViewName = request.getAuthorizedViewName();
        Query query = new Query(NameUtil.extractTargetId(tableName, authorizedViewName));
        query.builder = request.toBuilder();
        return query;
    }

    public Query clone() {
        Query query = Query.create(this.targetId);
        query.builder = this.builder.clone();
        return query;
    }

    private static ByteString wrapKey(String key) {
        if (key == null) {
            return null;
        }
        return ByteString.copyFromUtf8((String)key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Query query = (Query)o;
        return Objects.equal((Object)this.targetId, (Object)query.targetId) && Objects.equal((Object)this.builder.getRows(), (Object)query.builder.getRows()) && Objects.equal((Object)this.builder.getFilter(), (Object)query.builder.getFilter()) && Objects.equal((Object)this.builder.getRowsLimit(), (Object)query.builder.getRowsLimit());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.targetId, this.builder.getRows(), this.builder.getFilter(), this.builder.getRowsLimit()});
    }

    public String toString() {
        ReadRowsRequest request = this.builder.build();
        return MoreObjects.toStringHelper((Object)this).add("targetId", (Object)this.targetId).add("keys", (Object)request.getRows().getRowKeysList()).add("ranges", (Object)request.getRows().getRowRangesList()).add("filter", (Object)request.getFilter()).add("limit", request.getRowsLimit()).toString();
    }

    @BetaApi(value="This surface is stable yet it might be removed in the future.")
    public static class QueryPaginator {
        private final boolean hasOverallLimit;
        private long remainingRows;
        private Query query;
        private final int pageSize;
        private ByteString prevSplitPoint;

        QueryPaginator(@Nonnull Query query, int pageSize) {
            this.hasOverallLimit = query.builder.getRowsLimit() > 0L;
            this.remainingRows = query.builder.getRowsLimit();
            this.query = query.limit(pageSize);
            if (this.hasOverallLimit) {
                this.remainingRows -= (long)pageSize;
            }
            this.pageSize = pageSize;
            this.prevSplitPoint = ByteString.EMPTY;
        }

        public Query getNextQuery() {
            return this.query;
        }

        public boolean advance(@Nonnull ByteString lastSeenRowKey) {
            Preconditions.checkNotNull((Object)lastSeenRowKey, (Object)"lastSeenRowKey cannot be null, use ByteString.EMPTY instead.");
            if (lastSeenRowKey.equals((Object)this.prevSplitPoint)) {
                return false;
            }
            this.prevSplitPoint = lastSeenRowKey;
            if (this.hasOverallLimit && this.remainingRows <= 0L) {
                return false;
            }
            if (this.hasOverallLimit) {
                this.query.limit(Math.min((long)this.pageSize, this.remainingRows));
                this.remainingRows -= (long)this.pageSize;
            } else {
                this.query.limit(this.pageSize);
            }
            RowSet remaining = RowSetUtil.erase(this.query.builder.getRows(), lastSeenRowKey, !this.query.builder.getReversed());
            if (remaining == null) {
                return false;
            }
            this.query.builder.setRows(remaining);
            return true;
        }

        @InternalApi
        public int getPageSize() {
            return this.pageSize;
        }
    }
}

