/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.pgpdecryptstream;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.pgpdecryptstream.PGPDecryptStreamMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.PasswordTextVar;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class PGPDecryptStreamDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = PGPDecryptStreamMeta.class;
    private boolean gotPreviousFields = false;
    private TextVar wGPGLocation;
    private Label wlPassphrase;
    private TextVar wPassphrase;
    private CCombo wStreamFieldName;
    private TextVar wResult;
    private final PGPDecryptStreamMeta input;
    private Button wPassphraseFromField;
    private Label wlPassphraseFromField;
    private CCombo wPassphraseFieldName;
    private static final String[] FILETYPES = new String[]{BaseMessages.getString(PKG, (String)"PGPDecryptStreamDialog.Filetype.All", (String[])new String[0])};

    public PGPDecryptStreamDialog(Shell parent, IVariables variables, PGPDecryptStreamMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"PGPDecryptStreamDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"PGPDecryptStreamDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Group wGPGGroup = new Group((Composite)this.shell, 32);
        PropsUi.setLook((Widget)wGPGGroup);
        wGPGGroup.setText(BaseMessages.getString(PKG, (String)"PGPDecryptStreamDialog.GPGGroup.Label", (String[])new String[0]));
        FormLayout gpggroupgrouplayout = new FormLayout();
        gpggroupgrouplayout.marginWidth = 10;
        gpggroupgrouplayout.marginHeight = 10;
        wGPGGroup.setLayout((Layout)gpggroupgrouplayout);
        Label wlGPGLocation = new Label((Composite)wGPGGroup, 131072);
        wlGPGLocation.setText(BaseMessages.getString(PKG, (String)"PGPDecryptStreamDialog.GPGLocationField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlGPGLocation);
        FormData fdlGPGLocation = new FormData();
        fdlGPGLocation.left = new FormAttachment(0, 0);
        fdlGPGLocation.right = new FormAttachment(middle, -margin);
        fdlGPGLocation.top = new FormAttachment((Control)this.wTransformName, margin * 2);
        wlGPGLocation.setLayoutData((Object)fdlGPGLocation);
        Button wbbGpgExe = new Button((Composite)wGPGGroup, 0x1000008);
        PropsUi.setLook((Widget)wbbGpgExe);
        wbbGpgExe.setText(BaseMessages.getString(PKG, (String)"PGPDecryptStreamDialog.BrowseFiles.Label", (String[])new String[0]));
        FormData fdbbGpgExe = new FormData();
        fdbbGpgExe.right = new FormAttachment(100, -margin);
        fdbbGpgExe.top = new FormAttachment((Control)this.wTransformName, margin);
        wbbGpgExe.setLayoutData((Object)fdbbGpgExe);
        if (wbbGpgExe != null) {
            wbbGpgExe.addListener(13, e -> BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wGPGLocation, (IVariables)this.variables, (String[])new String[]{"*"}, (String[])new String[]{BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0])}, (boolean)true));
        }
        this.wGPGLocation = new TextVar(this.variables, (Composite)wGPGGroup, 18436);
        this.wGPGLocation.setToolTipText(BaseMessages.getString(PKG, (String)"PGPDecryptStreamDialog.GPGLocationField.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wGPGLocation);
        this.wGPGLocation.addModifyListener(lsMod);
        FormData fdGPGLocation = new FormData();
        fdGPGLocation.left = new FormAttachment(middle, 0);
        fdGPGLocation.top = new FormAttachment((Control)this.wTransformName, margin * 2);
        fdGPGLocation.right = new FormAttachment((Control)wbbGpgExe, -margin);
        this.wGPGLocation.setLayoutData((Object)fdGPGLocation);
        this.wlPassphrase = new Label((Composite)wGPGGroup, 131072);
        this.wlPassphrase.setText(BaseMessages.getString(PKG, (String)"PGPDecryptStreamDialog.PassphraseField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlPassphrase);
        FormData fdlPassphrase = new FormData();
        fdlPassphrase.left = new FormAttachment(0, 0);
        fdlPassphrase.right = new FormAttachment(middle, -margin);
        fdlPassphrase.top = new FormAttachment((Control)this.wGPGLocation, margin);
        this.wlPassphrase.setLayoutData((Object)fdlPassphrase);
        this.wPassphrase = new PasswordTextVar(this.variables, (Composite)wGPGGroup, 18436);
        this.wPassphrase.setToolTipText(BaseMessages.getString(PKG, (String)"PGPDecryptStreamDialog.PassphraseField.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wPassphrase);
        this.wPassphrase.addModifyListener(lsMod);
        FormData fdPassphrase = new FormData();
        fdPassphrase.left = new FormAttachment(middle, 0);
        fdPassphrase.top = new FormAttachment((Control)this.wGPGLocation, margin);
        fdPassphrase.right = new FormAttachment(100, 0);
        this.wPassphrase.setLayoutData((Object)fdPassphrase);
        this.wlPassphraseFromField = new Label((Composite)wGPGGroup, 131072);
        this.wlPassphraseFromField.setText(BaseMessages.getString(PKG, (String)"PGPDecryptStreamDialog.PassphraseFromField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlPassphraseFromField);
        FormData fdlPassphraseFromField = new FormData();
        fdlPassphraseFromField.left = new FormAttachment(0, 0);
        fdlPassphraseFromField.top = new FormAttachment((Control)this.wPassphrase, margin);
        fdlPassphraseFromField.right = new FormAttachment(middle, -margin);
        this.wlPassphraseFromField.setLayoutData((Object)fdlPassphraseFromField);
        this.wPassphraseFromField = new Button((Composite)wGPGGroup, 32);
        PropsUi.setLook((Widget)this.wPassphraseFromField);
        this.wPassphraseFromField.setToolTipText(BaseMessages.getString(PKG, (String)"PGPDecryptStreamDialog.PassphraseFromField.Tooltip", (String[])new String[0]));
        FormData fdPassphraseFromField = new FormData();
        fdPassphraseFromField.left = new FormAttachment(middle, 0);
        fdPassphraseFromField.top = new FormAttachment((Control)this.wlPassphraseFromField, 0, 0x1000000);
        this.wPassphraseFromField.setLayoutData((Object)fdPassphraseFromField);
        this.wPassphraseFromField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PGPDecryptStreamDialog.this.passphraseFromField();
            }
        });
        Label wlPassphraseFieldName = new Label((Composite)wGPGGroup, 131072);
        wlPassphraseFieldName.setText(BaseMessages.getString(PKG, (String)"PGPDecryptStreamDialog.PassphraseFieldName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlPassphraseFieldName);
        FormData fdlPassphraseFieldName = new FormData();
        fdlPassphraseFieldName.left = new FormAttachment(0, 0);
        fdlPassphraseFieldName.right = new FormAttachment(middle, -margin);
        fdlPassphraseFieldName.top = new FormAttachment((Control)this.wPassphraseFromField, margin);
        wlPassphraseFieldName.setLayoutData((Object)fdlPassphraseFieldName);
        this.wPassphraseFieldName = new CCombo((Composite)wGPGGroup, 2056);
        PropsUi.setLook((Widget)this.wPassphraseFieldName);
        this.wPassphraseFieldName.addModifyListener(lsMod);
        FormData fdPassphraseFieldName = new FormData();
        fdPassphraseFieldName.left = new FormAttachment(middle, 0);
        fdPassphraseFieldName.top = new FormAttachment((Control)this.wPassphraseFromField, margin);
        fdPassphraseFieldName.right = new FormAttachment(100, -margin);
        this.wPassphraseFieldName.setLayoutData((Object)fdPassphraseFieldName);
        this.wPassphraseFieldName.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)PGPDecryptStreamDialog.this.shell.getDisplay(), 1);
                PGPDecryptStreamDialog.this.shell.setCursor(busy);
                PGPDecryptStreamDialog.this.get();
                PGPDecryptStreamDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        FormData fdGPGGroup = new FormData();
        fdGPGGroup.left = new FormAttachment(0, margin);
        fdGPGGroup.top = new FormAttachment((Control)this.wTransformName, margin);
        fdGPGGroup.right = new FormAttachment(100, -margin);
        wGPGGroup.setLayoutData((Object)fdGPGGroup);
        Label wlStreamFieldName = new Label((Composite)this.shell, 131072);
        wlStreamFieldName.setText(BaseMessages.getString(PKG, (String)"PGPDecryptStreamDialog.StreamFieldName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlStreamFieldName);
        FormData fdlStreamFieldName = new FormData();
        fdlStreamFieldName.left = new FormAttachment(0, 0);
        fdlStreamFieldName.right = new FormAttachment(middle, -margin);
        fdlStreamFieldName.top = new FormAttachment((Control)wGPGGroup, 2 * margin);
        wlStreamFieldName.setLayoutData((Object)fdlStreamFieldName);
        this.wStreamFieldName = new CCombo((Composite)this.shell, 2056);
        PropsUi.setLook((Widget)this.wStreamFieldName);
        this.wStreamFieldName.addModifyListener(lsMod);
        FormData fdStreamFieldName = new FormData();
        fdStreamFieldName.left = new FormAttachment(middle, 0);
        fdStreamFieldName.top = new FormAttachment((Control)wGPGGroup, 2 * margin);
        fdStreamFieldName.right = new FormAttachment(100, -margin);
        this.wStreamFieldName.setLayoutData((Object)fdStreamFieldName);
        this.wStreamFieldName.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)PGPDecryptStreamDialog.this.shell.getDisplay(), 1);
                PGPDecryptStreamDialog.this.shell.setCursor(busy);
                PGPDecryptStreamDialog.this.get();
                PGPDecryptStreamDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        Label wlResult = new Label((Composite)this.shell, 131072);
        wlResult.setText(BaseMessages.getString(PKG, (String)"PGPDecryptStreamDialog.ResultField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlResult);
        FormData fdlResult = new FormData();
        fdlResult.left = new FormAttachment(0, 0);
        fdlResult.right = new FormAttachment(middle, -margin);
        fdlResult.top = new FormAttachment((Control)this.wStreamFieldName, margin * 2);
        wlResult.setLayoutData((Object)fdlResult);
        this.wResult = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.wResult.setToolTipText(BaseMessages.getString(PKG, (String)"PGPDecryptStreamDialog.ResultField.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wResult);
        this.wResult.addModifyListener(lsMod);
        FormData fdResult = new FormData();
        fdResult.left = new FormAttachment(middle, 0);
        fdResult.top = new FormAttachment((Control)this.wStreamFieldName, margin * 2);
        fdResult.right = new FormAttachment(100, 0);
        this.wResult.setLayoutData((Object)fdResult);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, (Control)this.wResult);
        this.getData();
        this.passphraseFromField();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        if (this.input.getGPGLocation() != null) {
            this.wGPGLocation.setText(this.input.getGPGLocation());
        }
        if (this.input.getStreamField() != null) {
            this.wStreamFieldName.setText(this.input.getStreamField());
        }
        if (this.input.getResultFieldName() != null) {
            this.wResult.setText(this.input.getResultFieldName());
        }
        if (this.input.getPassphrase() != null) {
            this.wPassphrase.setText(this.input.getPassphrase());
        }
        this.wPassphraseFromField.setSelection(this.input.isPassphraseFromField());
        if (this.input.getPassphraseFieldName() != null) {
            this.wPassphraseFieldName.setText(this.input.getPassphraseFieldName());
        }
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.input.setStreamField(this.wStreamFieldName.getText());
        this.input.setGPGLocation(this.wGPGLocation.getText());
        this.input.setPassphrase(this.wPassphrase.getText());
        this.input.setResultFieldName(this.wResult.getText());
        this.input.setPassphraseFromField(this.wPassphraseFromField.getSelection());
        this.input.setPassphraseFieldName(this.wPassphraseFieldName.getText());
        this.transformName = this.wTransformName.getText();
        this.dispose();
    }

    private void passphraseFromField() {
        this.wlPassphrase.setEnabled(!this.wPassphraseFromField.getSelection());
        this.wPassphrase.setEnabled(!this.wPassphraseFromField.getSelection());
        this.wlPassphraseFromField.setEnabled(this.wPassphraseFromField.getSelection());
        this.wPassphraseFromField.setEnabled(this.wPassphraseFromField.getSelection());
    }

    private void get() {
        if (!this.gotPreviousFields) {
            try {
                String fieldvalue = this.wStreamFieldName.getText();
                String passphrasefieldvalue = this.wPassphraseFieldName.getText();
                this.wStreamFieldName.removeAll();
                this.wPassphraseFieldName.removeAll();
                IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
                if (r != null) {
                    String[] fields = r.getFieldNames();
                    this.wStreamFieldName.setItems(fields);
                    this.wPassphraseFieldName.setItems(fields);
                }
                if (fieldvalue != null) {
                    this.wStreamFieldName.setText(fieldvalue);
                }
                if (passphrasefieldvalue != null) {
                    this.wPassphraseFieldName.setText(passphrasefieldvalue);
                }
                this.gotPreviousFields = true;
            }
            catch (HopException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"PGPDecryptStreamDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PGPDecryptStreamDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
        }
    }
}

