/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.cypherbuilder;

import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.metadata.api.HopMetadataProperty;

public class ReturnValue
implements Cloneable {
    @HopMetadataProperty
    private String alias;
    @HopMetadataProperty
    private String property;
    @HopMetadataProperty
    private String expression;
    @HopMetadataProperty
    private String parameter;
    @HopMetadataProperty
    private String rename;
    @HopMetadataProperty
    private String neoType;
    @HopMetadataProperty
    private String hopType;

    public ReturnValue() {
    }

    public ReturnValue(String alias, String property, String expression, String parameter, String rename, String neoType, String hopType) {
        this.alias = alias;
        this.property = property;
        this.expression = expression;
        this.parameter = parameter;
        this.rename = rename;
        this.neoType = neoType;
        this.hopType = hopType;
    }

    public ReturnValue(ReturnValue v) {
        this.alias = v.alias;
        this.property = v.property;
        this.expression = v.expression;
        this.rename = v.rename;
        this.neoType = v.neoType;
        this.hopType = v.hopType;
    }

    public ReturnValue clone() {
        return new ReturnValue(this);
    }

    public ReturnValue(String alias, String property) {
        this(alias, property, null, null, null, null, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReturnValue that = (ReturnValue)o;
        return Objects.equals(this.alias, that.alias) && Objects.equals(this.property, that.property) && Objects.equals(this.expression, that.expression) && Objects.equals(this.rename, that.rename) && Objects.equals(this.hopType, that.hopType);
    }

    public int hashCode() {
        return Objects.hash(this.alias, this.property, this.expression, this.rename, this.hopType);
    }

    public String getCypherClause() {
        StringBuilder cypher = new StringBuilder();
        cypher.append(this.getPropertyOrExpression());
        if (StringUtils.isNotEmpty((String)this.getRename())) {
            cypher.append(" AS ").append(this.getRename());
        }
        return cypher.toString();
    }

    public String getPropertyOrExpression() {
        if (StringUtils.isEmpty((String)this.expression)) {
            return this.getAliasProperty();
        }
        if (StringUtils.isEmpty((String)this.parameter)) {
            return this.expression;
        }
        return "{" + this.parameter + "}";
    }

    public String getAliasProperty() {
        return this.getAlias() + "." + this.getProperty();
    }

    public String calculateHeader() {
        if (StringUtils.isNotEmpty((String)this.rename)) {
            return this.rename;
        }
        return this.getPropertyOrExpression();
    }

    public IValueMeta createValueMeta() throws HopTransformException {
        try {
            String name = this.calculateHeader();
            int type = ValueMetaFactory.getIdForValueMeta((String)this.hopType);
            return ValueMetaFactory.createValueMeta((String)name, (int)type);
        }
        catch (Exception e) {
            throw new HopTransformException("Error creating Hop output value metadata", (Throwable)e);
        }
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getRename() {
        return this.rename;
    }

    public void setRename(String rename) {
        this.rename = rename;
    }

    public String getNeoType() {
        return this.neoType;
    }

    public void setNeoType(String neoType) {
        this.neoType = neoType;
    }

    public String getHopType() {
        return this.hopType;
    }

    public void setHopType(String hopType) {
        this.hopType = hopType;
    }
}

