/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.checkpoint.Checkpoint;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStats;
import org.apache.flink.runtime.checkpoint.MasterState;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobgraph.RestoreMode;
import org.apache.flink.runtime.state.CompletedCheckpointStorageLocation;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.StateUtil;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class CompletedCheckpoint
implements Serializable,
Checkpoint {
    private static final Logger LOG = LoggerFactory.getLogger(CompletedCheckpoint.class);
    private static final long serialVersionUID = -8360248179615702014L;
    private final JobID job;
    private final long checkpointID;
    private final long timestamp;
    private final long completionTimestamp;
    private final Map<OperatorID, OperatorState> operatorStates;
    private final CheckpointProperties props;
    @Nullable
    private final CheckpointProperties restoredProps;
    private final Collection<MasterState> masterHookStates;
    private final CompletedCheckpointStorageLocation storageLocation;
    private final StreamStateHandle metadataHandle;
    private final String externalPointer;
    @Nullable
    private final transient CompletedCheckpointStats completedCheckpointStats;

    public CompletedCheckpoint(JobID job, long checkpointID, long timestamp, long completionTimestamp, Map<OperatorID, OperatorState> operatorStates, @Nullable Collection<MasterState> masterHookStates, CheckpointProperties props, CompletedCheckpointStorageLocation storageLocation, @Nullable CompletedCheckpointStats completedCheckpointStats) {
        this(job, checkpointID, timestamp, completionTimestamp, operatorStates, masterHookStates, props, storageLocation, completedCheckpointStats, null);
    }

    public CompletedCheckpoint(JobID job, long checkpointID, long timestamp, long completionTimestamp, Map<OperatorID, OperatorState> operatorStates, @Nullable Collection<MasterState> masterHookStates, CheckpointProperties props, CompletedCheckpointStorageLocation storageLocation, @Nullable CompletedCheckpointStats completedCheckpointStats, @Nullable CheckpointProperties restoredProps) {
        Preconditions.checkArgument((checkpointID >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((timestamp >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((completionTimestamp >= 0L ? 1 : 0) != 0);
        this.job = (JobID)Preconditions.checkNotNull((Object)job);
        this.checkpointID = checkpointID;
        this.timestamp = timestamp;
        this.completionTimestamp = completionTimestamp;
        this.operatorStates = new HashMap<OperatorID, OperatorState>((Map)Preconditions.checkNotNull(operatorStates));
        this.masterHookStates = masterHookStates == null || masterHookStates.isEmpty() ? Collections.emptyList() : new ArrayList<MasterState>(masterHookStates);
        this.props = (CheckpointProperties)Preconditions.checkNotNull((Object)props);
        this.storageLocation = (CompletedCheckpointStorageLocation)Preconditions.checkNotNull((Object)storageLocation);
        this.metadataHandle = storageLocation.getMetadataHandle();
        this.externalPointer = storageLocation.getExternalPointer();
        this.completedCheckpointStats = completedCheckpointStats;
        this.restoredProps = restoredProps;
    }

    public JobID getJobId() {
        return this.job;
    }

    @Override
    public long getCheckpointID() {
        return this.checkpointID;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getCompletionTimestamp() {
        return this.completionTimestamp;
    }

    public CheckpointProperties getProperties() {
        return this.props;
    }

    public Optional<CheckpointProperties> getRestoredProperties() {
        return Optional.ofNullable(this.restoredProps);
    }

    public Map<OperatorID, OperatorState> getOperatorStates() {
        return this.operatorStates;
    }

    public Collection<MasterState> getMasterHookStates() {
        return Collections.unmodifiableCollection(this.masterHookStates);
    }

    public StreamStateHandle getMetadataHandle() {
        return this.metadataHandle;
    }

    public String getExternalPointer() {
        return this.externalPointer;
    }

    public long getStateSize() {
        long result = 0L;
        for (OperatorState operatorState : this.operatorStates.values()) {
            result += operatorState.getStateSize();
        }
        return result;
    }

    public void registerSharedStatesAfterRestored(SharedStateRegistry sharedStateRegistry, RestoreMode restoreMode) {
        if (!this.props.isUnclaimed()) {
            sharedStateRegistry.registerAllAfterRestored(this, restoreMode);
        }
    }

    @Override
    public Checkpoint.DiscardObject markAsDiscarded() {
        if (this.completedCheckpointStats != null) {
            this.completedCheckpointStats.discard();
        }
        return new CompletedCheckpointDiscardObject();
    }

    public Checkpoint.DiscardObject markAsDiscardedOnSubsume() {
        return this.shouldBeDiscardedOnSubsume() ? this.markAsDiscarded() : NOOP_DISCARD_OBJECT;
    }

    public Checkpoint.DiscardObject markAsDiscardedOnShutdown(JobStatus jobStatus) {
        return this.shouldBeDiscardedOnShutdown(jobStatus) ? this.markAsDiscarded() : NOOP_DISCARD_OBJECT;
    }

    public boolean shouldBeDiscardedOnSubsume() {
        return this.props.discardOnSubsumed();
    }

    public boolean shouldBeDiscardedOnShutdown(JobStatus jobStatus) {
        return jobStatus == JobStatus.FINISHED && this.props.discardOnJobFinished() || jobStatus == JobStatus.CANCELED && this.props.discardOnJobCancelled() || jobStatus == JobStatus.FAILED && this.props.discardOnJobFailed() || jobStatus == JobStatus.SUSPENDED && this.props.discardOnJobSuspended();
    }

    public static boolean checkpointsMatch(Collection<CompletedCheckpoint> first, Collection<CompletedCheckpoint> second) {
        if (first.size() != second.size()) {
            return false;
        }
        ArrayList<Tuple2> firstInterestingFields = new ArrayList<Tuple2>(first.size());
        for (CompletedCheckpoint checkpoint : first) {
            firstInterestingFields.add(new Tuple2((Object)checkpoint.getCheckpointID(), (Object)checkpoint.getJobId()));
        }
        ArrayList<Tuple2> secondInterestingFields = new ArrayList<Tuple2>(second.size());
        for (CompletedCheckpoint checkpoint : second) {
            secondInterestingFields.add(new Tuple2((Object)checkpoint.getCheckpointID(), (Object)checkpoint.getJobId()));
        }
        return firstInterestingFields.equals(secondInterestingFields);
    }

    @Nullable
    public CompletedCheckpointStats getStatistic() {
        return this.completedCheckpointStats;
    }

    public String toString() {
        return String.format("%s %d @ %d for %s located at %s", this.props.getCheckpointType().getName(), this.checkpointID, this.timestamp, this.job, this.externalPointer);
    }

    @NotThreadSafe
    public class CompletedCheckpointDiscardObject
    implements Checkpoint.DiscardObject {
        @Override
        public void discard() throws Exception {
            LOG.trace("Executing discard procedure for {}.", (Object)this);
            Preconditions.checkState((boolean)this.isMarkedAsDiscarded(), (Object)"Checkpoint should be marked as discarded before discard.");
            try {
                Exception exception = null;
                try {
                    CompletedCheckpoint.this.metadataHandle.discardState();
                }
                catch (Exception e) {
                    exception = e;
                }
                try {
                    StateUtil.bestEffortDiscardAllStateObjects(CompletedCheckpoint.this.operatorStates.values());
                }
                catch (Exception e) {
                    exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
                }
                try {
                    CompletedCheckpoint.this.storageLocation.disposeStorageLocation();
                }
                catch (Exception e) {
                    exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
                }
                if (exception != null) {
                    throw exception;
                }
            }
            finally {
                CompletedCheckpoint.this.operatorStates.clear();
            }
        }

        private boolean isMarkedAsDiscarded() {
            return CompletedCheckpoint.this.completedCheckpointStats == null || CompletedCheckpoint.this.completedCheckpointStats.isDiscarded();
        }

        @Override
        public CompletableFuture<Void> discardAsync(Executor ioExecutor) {
            Preconditions.checkState((boolean)this.isMarkedAsDiscarded(), (Object)"Checkpoint should be marked as discarded before discard.");
            List discardables = CompletedCheckpoint.this.operatorStates.values().stream().flatMap(op -> op.getDiscardables().stream()).collect(Collectors.toList());
            discardables.add(CompletedCheckpoint.this.metadataHandle);
            FutureUtils.ConjunctFuture discardStates = FutureUtils.completeAll((Collection)discardables.stream().map(item -> FutureUtils.runAsync(item::discardState, (Executor)ioExecutor)).collect(Collectors.toList()));
            return FutureUtils.runAfterwards((CompletableFuture)discardStates, () -> {
                CompletedCheckpoint.this.operatorStates.clear();
                CompletedCheckpoint.this.storageLocation.disposeStorageLocation();
            });
        }
    }
}

