/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.ManagedIdentityServiceCredential;
import com.azure.identity.implementation.IdentityClient;
import reactor.core.publisher.Mono;

class ArcIdentityCredential
extends ManagedIdentityServiceCredential {
    private static final ClientLogger LOGGER = new ClientLogger(ArcIdentityCredential.class);
    private final String identityEndpoint;

    ArcIdentityCredential(String clientId, IdentityClient identityClient) {
        super(clientId, identityClient, "AZURE ARC IDENTITY ENDPOINT");
        Configuration configuration = Configuration.getGlobalConfiguration().clone();
        this.identityEndpoint = configuration.get("IDENTITY_ENDPOINT");
        if (this.identityEndpoint != null) {
            this.validateEndpointProtocol(this.identityEndpoint, "Identity", LOGGER);
        }
    }

    @Override
    public Mono<AccessToken> authenticate(TokenRequestContext request) {
        if (this.getClientId() != null) {
            return Mono.error((Throwable)LOGGER.logExceptionAsError((RuntimeException)new ClientAuthenticationException("User assigned identity is not supported by the Azure Arc Managed Identity Endpoint. To authenticate with the system assigned identity omit the client id when constructing the ManagedIdentityCredential.", null)));
        }
        return this.identityClient.authenticateWithManagedIdentityConfidentialClient(request);
    }
}

