/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.excelinput.poi;

import java.sql.Date;
import java.util.TimeZone;
import org.apache.hop.core.spreadsheet.IKCell;
import org.apache.hop.core.spreadsheet.KCellType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;

public class PoiCell
implements IKCell {
    private Cell cell;

    public PoiCell(Cell cell) {
        this.cell = cell;
    }

    public KCellType getType() {
        switch (this.cell.getCellType()) {
            case BOOLEAN: {
                return KCellType.BOOLEAN;
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)this.cell)) {
                    return KCellType.DATE;
                }
                return KCellType.NUMBER;
            }
            case STRING: {
                return KCellType.LABEL;
            }
            case BLANK: 
            case ERROR: {
                return KCellType.EMPTY;
            }
            case FORMULA: {
                switch (this.cell.getCachedFormulaResultType()) {
                    case BLANK: 
                    case ERROR: {
                        return KCellType.EMPTY;
                    }
                    case BOOLEAN: {
                        return KCellType.BOOLEAN_FORMULA;
                    }
                    case STRING: {
                        return KCellType.STRING_FORMULA;
                    }
                    case NUMERIC: {
                        if (DateUtil.isCellDateFormatted((Cell)this.cell)) {
                            return KCellType.DATE_FORMULA;
                        }
                        return KCellType.NUMBER_FORMULA;
                    }
                }
            }
        }
        return null;
    }

    public Object getValue() {
        try {
            switch (this.getType()) {
                case BOOLEAN_FORMULA: 
                case BOOLEAN: {
                    return this.cell.getBooleanCellValue();
                }
                case DATE_FORMULA: 
                case DATE: {
                    long time = this.cell.getDateCellValue().getTime();
                    long tzOffset = TimeZone.getDefault().getOffset(time);
                    return new Date(time + tzOffset);
                }
                case NUMBER_FORMULA: 
                case NUMBER: {
                    return this.cell.getNumericCellValue();
                }
                case STRING_FORMULA: 
                case LABEL: {
                    return this.cell.getStringCellValue();
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get value of cell (" + this.cell.getColumnIndex() + ", " + this.cell.getRowIndex() + ")", e);
        }
    }

    public String getContents() {
        try {
            Object value = this.getValue();
            if (value == null) {
                return null;
            }
            return value.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get string content of cell (" + this.cell.getColumnIndex() + ", " + this.cell.getRowIndex() + ")", e);
        }
    }

    public int getRow() {
        Row row = this.cell.getRow();
        return row.getRowNum();
    }
}

