/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.xml.xsdvalidator;

import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.xml.xsdvalidator.XsdValidator;
import org.apache.hop.pipeline.transforms.xml.xsdvalidator.XsdValidatorData;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;
import org.w3c.dom.Node;

@Transform(id="XSDValidator", image="XOU.svg", name="i18n::XSDValidator.name", description="i18n::XSDValidator.description", categoryDescription="i18n::XSDValidator.category", keywords={"i18n::XsdValidatorMeta.keyword"}, documentationUrl="/pipeline/transforms/xsdvalidator.html")
public class XsdValidatorMeta
extends BaseTransformMeta<XsdValidator, XsdValidatorData> {
    private static final Class<?> PKG = XsdValidatorMeta.class;
    private String xsdFilename;
    private String xmlStream;
    private String resultFieldname;
    private boolean addValidationMessage;
    private String validationMessageField;
    private boolean outputStringField;
    private String ifXmlValid;
    private String ifXmlInvalid;
    private boolean xmlSourceFile;
    private String xsdDefinedField;
    private String xsdSource;
    private boolean allowExternalEntities = Boolean.valueOf(System.getProperties().getProperty("ALLOW_EXTERNAL_ENTITIES_FOR_XSD_VALIDATION", "true"));
    public String SPECIFY_FILENAME = "filename";
    public String SPECIFY_FIELDNAME = "fieldname";
    public String NO_NEED = "noneed";
    public static final String ALLOW_EXTERNAL_ENTITIES_FOR_XSD_VALIDATION = "ALLOW_EXTERNAL_ENTITIES_FOR_XSD_VALIDATION";
    public static final String ALLOW_EXTERNAL_ENTITIES_FOR_XSD_VALIDATION_DEFAULT = "true";

    public boolean isAllowExternalEntities() {
        return this.allowExternalEntities;
    }

    public void setAllowExternalEntities(boolean allowExternalEntities) {
        this.allowExternalEntities = allowExternalEntities;
    }

    public void setXSDSource(String xsdsourcein) {
        this.xsdSource = xsdsourcein;
    }

    public String getXSDSource() {
        return this.xsdSource;
    }

    public void setXSDDefinedField(String xsddefinedfieldin) {
        this.xsdDefinedField = xsddefinedfieldin;
    }

    public String getXSDDefinedField() {
        return this.xsdDefinedField;
    }

    public boolean getXMLSourceFile() {
        return this.xmlSourceFile;
    }

    public void setXMLSourceFile(boolean xmlsourcefilein) {
        this.xmlSourceFile = xmlsourcefilein;
    }

    public String getIfXmlValid() {
        return this.ifXmlValid;
    }

    public String getIfXmlInvalid() {
        return this.ifXmlInvalid;
    }

    public void setIfXMLValid(String ifXmlValid) {
        this.ifXmlValid = ifXmlValid;
    }

    public void setIfXmlInvalid(String ifXmlInvalid) {
        this.ifXmlInvalid = ifXmlInvalid;
    }

    public boolean getOutputStringField() {
        return this.outputStringField;
    }

    public void setOutputStringField(boolean outputStringField) {
        this.outputStringField = outputStringField;
    }

    public String getValidationMessageField() {
        return this.validationMessageField;
    }

    public void setValidationMessageField(String validationMessageField) {
        this.validationMessageField = validationMessageField;
    }

    public boolean useAddValidationMessage() {
        return this.addValidationMessage;
    }

    public void setAddValidationMessage(boolean addValidationMessage) {
        this.addValidationMessage = addValidationMessage;
    }

    public String getXSDFilename() {
        return this.xsdFilename;
    }

    public String getResultfieldname() {
        return this.resultFieldname;
    }

    public String getXMLStream() {
        return this.xmlStream;
    }

    public void setXSDfilename(String xdsFilename) {
        this.xsdFilename = xdsFilename;
    }

    public void setResultfieldname(String resultFieldname) {
        this.resultFieldname = resultFieldname;
    }

    public void setXMLStream(String xmlStream) {
        this.xmlStream = xmlStream;
    }

    public Object clone() {
        XsdValidatorMeta retval = (XsdValidatorMeta)((Object)super.clone());
        return retval;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            this.xsdFilename = XmlHandler.getTagValue((Node)transformNode, (String)"xdsfilename");
            this.xmlStream = XmlHandler.getTagValue((Node)transformNode, (String)"xmlstream");
            this.resultFieldname = XmlHandler.getTagValue((Node)transformNode, (String)"resultfieldname");
            this.xsdDefinedField = XmlHandler.getTagValue((Node)transformNode, (String)"xsddefinedfield");
            this.xsdSource = XmlHandler.getTagValue((Node)transformNode, (String)"xsdsource");
            this.addValidationMessage = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"addvalidationmsg"));
            this.validationMessageField = XmlHandler.getTagValue((Node)transformNode, (String)"validationmsgfield");
            this.ifXmlValid = XmlHandler.getTagValue((Node)transformNode, (String)"ifxmlvalid");
            this.ifXmlInvalid = XmlHandler.getTagValue((Node)transformNode, (String)"ifxmlunvalid");
            this.outputStringField = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"outputstringfield"));
            this.xmlSourceFile = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"xmlsourcefile"));
            this.allowExternalEntities = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"allowExternalEntities"));
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"XsdValidatorMeta.Exception.UnableToLoadTransformInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.xsdFilename = "";
        this.xmlStream = "";
        this.resultFieldname = "result";
        this.addValidationMessage = false;
        this.validationMessageField = "ValidationMsgField";
        this.ifXmlValid = "";
        this.ifXmlInvalid = "";
        this.outputStringField = false;
        this.xmlSourceFile = false;
        this.xsdDefinedField = "";
        this.xsdSource = this.SPECIFY_FILENAME;
        this.allowExternalEntities = Boolean.valueOf(System.getProperties().getProperty(ALLOW_EXTERNAL_ENTITIES_FOR_XSD_VALIDATION, ALLOW_EXTERNAL_ENTITIES_FOR_XSD_VALIDATION_DEFAULT));
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        ValueMetaString v;
        if (!Utils.isEmpty((CharSequence)this.resultFieldname)) {
            if (this.outputStringField) {
                v = new ValueMetaString(variables.resolve(this.getResultfieldname()));
                inputRowMeta.addValueMeta((IValueMeta)v);
            } else {
                v = new ValueMetaBoolean(variables.resolve(this.getResultfieldname()));
                inputRowMeta.addValueMeta((IValueMeta)v);
            }
        }
        if (this.addValidationMessage && !Utils.isEmpty((CharSequence)this.validationMessageField)) {
            v = new ValueMetaString(variables.resolve(this.validationMessageField));
            inputRowMeta.addValueMeta((IValueMeta)v);
        }
    }

    public String getXml() {
        StringBuffer xml = new StringBuffer();
        xml.append("    " + XmlHandler.addTagValue((String)"xdsfilename", (String)this.xsdFilename));
        xml.append("    " + XmlHandler.addTagValue((String)"xmlstream", (String)this.xmlStream));
        xml.append("    " + XmlHandler.addTagValue((String)"resultfieldname", (String)this.resultFieldname));
        xml.append("    " + XmlHandler.addTagValue((String)"addvalidationmsg", (boolean)this.addValidationMessage));
        xml.append("    " + XmlHandler.addTagValue((String)"validationmsgfield", (String)this.validationMessageField));
        xml.append("    " + XmlHandler.addTagValue((String)"ifxmlunvalid", (String)this.ifXmlInvalid));
        xml.append("    " + XmlHandler.addTagValue((String)"ifxmlvalid", (String)this.ifXmlValid));
        xml.append("    " + XmlHandler.addTagValue((String)"outputstringfield", (boolean)this.outputStringField));
        xml.append("    " + XmlHandler.addTagValue((String)"xmlsourcefile", (boolean)this.xmlSourceFile));
        xml.append("    " + XmlHandler.addTagValue((String)"xsddefinedfield", (String)this.xsdDefinedField));
        xml.append("    " + XmlHandler.addTagValue((String)"xsdsource", (String)this.xsdSource));
        xml.append("    " + XmlHandler.addTagValue((String)"allowExternalEntities", (boolean)this.allowExternalEntities));
        return xml.toString();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transforminfo, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (Utils.isEmpty((CharSequence)this.xmlStream)) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XsdValidatorMeta.CheckResult.XMLStreamFieldEmpty", (String[])new String[0]), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XsdValidatorMeta.CheckResult.XMLStreamFieldOK", (String[])new String[0]), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
        }
        if (Utils.isEmpty((CharSequence)this.resultFieldname)) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XsdValidatorMeta.CheckResult.ResultFieldEmpty", (String[])new String[0]), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XsdValidatorMeta.CheckResult.ResultFieldOK", (String[])new String[0]), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
        }
        if (this.xsdSource.equals(this.SPECIFY_FILENAME) && Utils.isEmpty((CharSequence)this.xsdFilename)) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XsdValidatorMeta.CheckResult.XSDFieldEmpty", (String[])new String[0]), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
        }
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XsdValidatorMeta.CheckResult.ConnectedTransformOK", (String[])new String[]{String.valueOf(prev.size())}), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XsdValidatorMeta.CheckResult.NoInputReceived", (String[])new String[0]), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XsdValidatorMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XsdValidatorMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming resourceNamingInterface, IHopMetadataProvider metadataProvider) throws HopException {
        try {
            if (!Utils.isEmpty((CharSequence)this.xsdFilename)) {
                FileObject fileObject = HopVfs.getFileObject((String)variables.resolve(this.xsdFilename), (IVariables)variables);
                this.xsdFilename = resourceNamingInterface.nameResource(fileObject, variables, true);
                return this.xsdFilename;
            }
            return null;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }
}

