/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class FileUtil {
    public static final String EOL = System.getProperty("line.separator");

    public static String toString(File file) throws IOException {
        FileInputStream fin = new FileInputStream(file);
        return FileUtil.toString(fin);
    }

    public static byte[] toBytes(InputStream in) throws IOException {
        int ch;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        while ((ch = in.read()) != -1) {
            bout.write(ch);
        }
        in.close();
        return bout.toByteArray();
    }

    public static void copy(InputStream from, OutputStream to) throws IOException {
        FileUtil.copy(from, to, true);
    }

    public static void copy(InputStream from, OutputStream to, boolean closeOutput) throws IOException {
        FileUtil.copy(from, true, to, closeOutput);
    }

    public static void copy(InputStream from, boolean closeInput, OutputStream to, boolean closeOutput) throws IOException {
        try {
            int count;
            byte[] buf = new byte[1024];
            while ((count = from.read(buf, 0, buf.length)) != -1) {
                to.write(buf, 0, count);
            }
        }
        finally {
            try {
                if (closeOutput) {
                    to.close();
                }
            }
            finally {
                if (closeInput) {
                    from.close();
                }
            }
        }
    }

    private static String toString(InputStream in) throws IOException {
        return new String(FileUtil.toBytes(in));
    }

    public static File mkdirs(String packageName, File root) {
        String[] dirs;
        String[] stringArray = dirs = packageName.split("\\.");
        int n = dirs.length;
        int n2 = 0;
        while (n2 < n) {
            String dir = stringArray[n2];
            File f = new File(root, dir);
            if (!f.exists()) {
                f.mkdir();
            }
            root = f;
            ++n2;
        }
        return root;
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children;
            String[] stringArray = children = dir.list();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                String child = stringArray[n2];
                boolean success = FileUtil.deleteDir(new File(dir, child));
                if (!success) {
                    return false;
                }
                ++n2;
            }
        }
        return dir.delete();
    }

    public static List<File> listFilesRecursive(File dir, boolean includeDirs) {
        ArrayList<File> result = null;
        if (dir.isDirectory()) {
            result = new ArrayList<File>();
            FileUtil.listFilesRecursive(dir, result, includeDirs);
        }
        return result;
    }

    private static void listFilesRecursive(File dir, List<File> result, boolean includeDirs) {
        String[] stringArray = dir.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String child = stringArray[n2];
            File f = new File(dir, child);
            if (f.isDirectory()) {
                if (includeDirs) {
                    result.add(f);
                }
                FileUtil.listFilesRecursive(f, result, includeDirs);
            } else {
                result.add(f);
            }
            ++n2;
        }
    }

    public static File makeTempDirectory(String dirName, boolean deleteIfExists) throws IOException {
        return FileUtil.makeTempDirectory(null, dirName, deleteIfExists);
    }

    public static File makeTempDirectory(File parentTempDir, String dirName, boolean deleteIfExists) throws IOException {
        File dir = new File(FileUtil.getSystemTempDirectory(parentTempDir), dirName);
        if (dir.exists()) {
            if (deleteIfExists) {
                FileUtil.deleteDir(dir);
            } else {
                throw new IOException("Cannot create directory that already exists: " + dir);
            }
        }
        dir.mkdirs();
        dir.deleteOnExit();
        return dir;
    }

    public static File getSystemTempDirectory(File parentTempDir) throws IOException {
        if (parentTempDir != null && parentTempDir.exists() && parentTempDir.isDirectory()) {
            return parentTempDir;
        }
        File t = File.createTempFile("java", ".tmp", parentTempDir);
        try {
            File file = t.getParentFile();
            return file;
        }
        finally {
            t.delete();
        }
    }
}

