/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.SystemPool;
import com.ibm.as400.access.SystemStatus;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.AS400DetailsPane;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ListSelectionEventSupport;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VActionContext;
import com.ibm.as400.vaccess.VNode;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VSystemStatus;
import com.ibm.as400.vaccess.VUtilities;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class VSystemStatusPane
extends JPanel
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    AS400DetailsPane detailsPane_;
    private AS400 system_;
    private SystemStatus systemStatus_;
    private VSystemStatus vSystemStatus_;
    private JLabel systemLabel_ = new JLabel();
    private JLabel dateTimeLabel_ = new JLabel();
    private JLabel utilizationLabel_ = new JLabel();
    private JLabel systemASPLabel_ = new JLabel();
    private JLabel systemASPUsedLabel_ = new JLabel();
    private JLabel totalAuxiliaryStorageLabel_ = new JLabel();
    private JLabel jobsInSystemLabel_ = new JLabel();
    private JLabel batchJobsRunningLabel_ = new JLabel();
    private JLabel usersCurrentlySignedOnLabel_ = new JLabel();
    private boolean allowModifyAllPools_ = false;
    private static DateFormat dateFormat_ = DateFormat.getDateInstance();
    private static DateFormat timeFormat_ = DateFormat.getTimeInstance();
    private static final String systemStatusText_ = ResourceLoader.getText("SYSTEM_STATUS_SYSTEM_STATUS");
    private static final String systemText_ = ResourceLoader.getText("SYSTEM_STATUS_SYSTEM") + ":";
    private static final String datetimeText_ = ResourceLoader.getText("SYSTEM_STATUS_DATE_TIME") + ":";
    private static final String cpuText_ = ResourceLoader.getText("SYSTEM_STATUS_CPU");
    private static final String utilizationText_ = "     " + ResourceLoader.getText("SYSTEM_STATUS_UTILIZATION") + ":";
    private static final String auxiliaryStorageText_ = ResourceLoader.getText("SYSTEM_STATUS_AUXILIARY_STORAGE");
    private static final String systemAspText_ = "     " + ResourceLoader.getText("SYSTEM_STATUS_SYSTEM_ASP") + ":";
    private static final String systemAspUsedText_ = "     " + ResourceLoader.getText("SYSTEM_STATUS_SYSTEM_ASP_USED") + ":";
    private static final String totalAuxiliaryStorageText_ = "     " + ResourceLoader.getText("SYSTEM_STATUS_TOTAL_AUXILIARY_STORAGE") + ":";
    private static final String jobsText_ = ResourceLoader.getText("SYSTEM_STATUS_JOBS");
    private static final String jobsInSystemText_ = "     " + ResourceLoader.getText("SYSTEM_STATUS_JOBS_IN_SYSTEM") + ":";
    private static final String batchJobsRunningText_ = "     " + ResourceLoader.getText("SYSTEM_STATUS_BATCH_JOBS_RUNNING") + ":";
    private static final String usersText_ = ResourceLoader.getText("SYSTEM_STATUS_USERS");
    private static final String usersCurrentlySignedOnText_ = "     " + ResourceLoader.getText("SYSTEM_STATUS_USERS_CURRENTLY_SIGNED_ON") + ":";
    private static final String storagePoolsText_ = ResourceLoader.getText("SYSTEM_STATUS_STORAGE_POOLS");
    private transient ErrorEventSupport errorEventSupport_;
    private transient ListSelectionEventSupport listSelectionEventSupport_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;
    private transient WorkingEventSupport workingEventSupport_;

    public VSystemStatusPane(AS400 system) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.system_ = system;
        GridBagLayout panelLayout = new GridBagLayout();
        this.setLayout(panelLayout);
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        GridBagConstraints gbc = new GridBagConstraints();
        VUtilities.constrain(this.getPanel0(), this, panelLayout, gbc, 0, 1, 1, 0, 1, 0, 0, 10);
        VUtilities.constrain(this.getPanel1(), this, panelLayout, gbc, 0, 1, 1, 1, 1, 0, 0, 10);
        VUtilities.constrain(new JLabel(storagePoolsText_), this, panelLayout, gbc, 0, 1, 1, 2, 1, 0, 0, 17);
        VUtilities.constrain(this.getPanel2(), this, panelLayout, gbc, 0, 1, 1, 3, 1, 1, 1, 10);
        this.initializeTransient();
    }

    public void addErrorListener(ErrorListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.errorEventSupport_.addErrorListener(listener);
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.listSelectionEventSupport_.addListSelectionListener(listener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.propertyChangeSupport_.addPropertyChangeListener(listener);
    }

    @Override
    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.vetoableChangeSupport_.addVetoableChangeListener(listener);
    }

    public VActionContext getActionContext() {
        return this.detailsPane_.getActionContext();
    }

    public boolean getAllowActions() {
        return this.detailsPane_.getAllowActions();
    }

    public TableColumnModel getDetailsColumnModel() {
        return this.detailsPane_.getColumnModel();
    }

    public TableModel getDetailsModel() {
        return this.detailsPane_.getModel();
    }

    public ListSelectionModel getDetailsSelectionModel() {
        return this.detailsPane_.getSelectionModel();
    }

    private JPanel getPanel0() {
        JPanel panel0 = new JPanel();
        panel0.add(new JLabel(systemStatusText_));
        return panel0;
    }

    private JPanel getPanel1() {
        JPanel panel1 = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel1.setLayout(layout);
        int row = 0;
        VUtilities.constrain(new JLabel(systemText_), this.systemLabel_, panel1, layout, row++);
        VUtilities.constrain(new JLabel(datetimeText_), this.dateTimeLabel_, panel1, layout, row++);
        VUtilities.constrain(new JLabel(cpuText_), panel1, layout, row++);
        VUtilities.constrain(new JLabel(utilizationText_), this.utilizationLabel_, panel1, layout, row++);
        VUtilities.constrain(new JLabel(auxiliaryStorageText_), panel1, layout, row++);
        VUtilities.constrain(new JLabel(systemAspText_), this.systemASPLabel_, panel1, layout, row++);
        VUtilities.constrain(new JLabel(systemAspUsedText_), this.systemASPUsedLabel_, panel1, layout, row++);
        VUtilities.constrain(new JLabel(totalAuxiliaryStorageText_), this.totalAuxiliaryStorageLabel_, panel1, layout, row++);
        VUtilities.constrain(new JLabel(jobsText_), panel1, layout, row++);
        VUtilities.constrain(new JLabel(jobsInSystemText_), this.jobsInSystemLabel_, panel1, layout, row++);
        VUtilities.constrain(new JLabel(batchJobsRunningText_), this.batchJobsRunningLabel_, panel1, layout, row++);
        VUtilities.constrain(new JLabel(usersText_), panel1, layout, row++);
        VUtilities.constrain(new JLabel(usersCurrentlySignedOnText_), this.usersCurrentlySignedOnLabel_, panel1, layout, row++);
        return panel1;
    }

    private JPanel getPanel2() {
        JPanel panel2 = new JPanel();
        this.detailsPane_ = new AS400DetailsPane();
        panel2.setLayout(new BorderLayout());
        panel2.add("Center", this.detailsPane_);
        return panel2;
    }

    public VObject getSelectedObject() {
        VObject vObjec1 = this.detailsPane_.getSelectedObject();
        return vObjec1;
    }

    public VObject[] getSelectedObjects() {
        VObject[] vObjec1 = this.detailsPane_.getSelectedObjects();
        return vObjec1;
    }

    public VSystemStatus getVSystemStatus() {
        return this.vSystemStatus_;
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.listSelectionEventSupport_ = new ListSelectionEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.detailsPane_.addErrorListener(this.errorEventSupport_);
        this.detailsPane_.addListSelectionListener(this.listSelectionEventSupport_);
        this.detailsPane_.addPropertyChangeListener(this.propertyChangeSupport_);
        this.detailsPane_.addVetoableChangeListener(this.vetoableChangeSupport_);
    }

    public boolean isAllowModifyAllPools() {
        return this.allowModifyAllPools_;
    }

    public void load() {
        this.workingEventSupport_.fireStartWorking();
        if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
            Trace.log(3, "VSystemStatusPane: loading");
        }
        try {
            if (this.systemStatus_ == null) {
                this.systemStatus_ = new SystemStatus(this.system_);
            } else {
                this.systemStatus_.refreshCache();
            }
            Enumeration e = this.systemStatus_.getSystemPools();
            while (e.hasMoreElements()) {
                ((SystemPool)e.nextElement()).addPropertyChangeListener(this.propertyChangeSupport_);
            }
        }
        catch (Exception ex) {
            Trace.log(2, ex.toString());
            this.errorEventSupport_.fireError(ex);
        }
        try {
            if (this.vSystemStatus_ == null) {
                this.vSystemStatus_ = new VSystemStatus(this.systemStatus_);
            } else {
                this.vSystemStatus_.load();
            }
        }
        catch (Exception ex) {
            Trace.log(2, ex.toString());
            this.errorEventSupport_.fireError(ex);
        }
        this.vSystemStatus_.setAllowModifyAllPools(this.allowModifyAllPools_);
        this.systemLabel_.setText(this.systemStatus_.getSystem().getSystemName());
        try {
            Date date = this.systemStatus_.getDateAndTimeStatusGathered();
            String dateStr = dateFormat_.format(date);
            String timeStr = timeFormat_.format(date);
            this.dateTimeLabel_.setText(dateStr + "  " + timeStr);
            this.utilizationLabel_.setText(Float.toString(this.systemStatus_.getPercentProcessingUnitUsed()));
            this.systemASPLabel_.setText(Integer.toString(this.systemStatus_.getSystemASP()));
            this.systemASPUsedLabel_.setText(Float.toString(this.systemStatus_.getPercentSystemASPUsed()));
            this.totalAuxiliaryStorageLabel_.setText(Integer.toString(this.systemStatus_.getTotalAuxiliaryStorage()));
            this.jobsInSystemLabel_.setText(Integer.toString(this.systemStatus_.getJobsInSystem()));
            this.batchJobsRunningLabel_.setText(Integer.toString(this.systemStatus_.getBatchJobsRunning()));
            this.usersCurrentlySignedOnLabel_.setText(Integer.toString(this.systemStatus_.getUsersCurrentSignedOn()));
        }
        catch (Exception e) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, e);
            }
            this.errorEventSupport_.fireError(e);
        }
        try {
            this.detailsPane_.setRoot(this.vSystemStatus_);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.detailsPane_.load();
        if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
            Trace.log(3, "VSystemStatusPane: load finished");
        }
        this.workingEventSupport_.fireStopWorking();
    }

    public void removeErrorListener(ErrorListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.errorEventSupport_.removeErrorListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.listSelectionEventSupport_.removeListSelectionListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.propertyChangeSupport_.removePropertyChangeListener(listener);
    }

    @Override
    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.vetoableChangeSupport_.removeVetoableChangeListener(listener);
    }

    public void setAllowActions(boolean allowAction) {
        this.detailsPane_.setAllowActions(allowAction);
    }

    public void setAllowModifyAllPools(boolean allow) {
        this.allowModifyAllPools_ = allow;
    }

    public void setConfirm(boolean confirm) {
        this.detailsPane_.setConfirm(confirm);
    }

    public void setDetailsSelectionModel(ListSelectionModel listSe1) {
        this.detailsPane_.setSelectionModel(listSe1);
    }

    public void setRoot(VNode root) throws PropertyVetoException {
        if (root == null) {
            throw new NullPointerException("root");
        }
        this.detailsPane_.setRoot(root);
    }

    public void sort(Object[] propertyIdentifiers, boolean[] orders) {
        this.detailsPane_.sort(propertyIdentifiers, orders);
    }
}

