/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.lib.util;

import java.io.Serializable;
import java.util.Map;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.lib.util.Maybe$One$;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.runtime.function.JProcedure1;

public class NonAllocatingMap<K, V> {
    private final Map<K, V> javaMap;

    public NonAllocatingMap(Map<K, V> javaMap) {
        this.javaMap = javaMap;
    }

    public Object get(K k) {
        V got = this.javaMap.get(k);
        if (got == null) {
            return Maybe$.MODULE$.Nope();
        }
        return Maybe$One$.MODULE$.apply(got);
    }

    public void put(K k, V v) {
        K ar;
        K k2 = k;
        if (k2 instanceof Object && (ar = k2) == null) {
            throw Assert$.MODULE$.usageError("ar.ne(null)");
        }
        if (v == null) {
            throw Assert$.MODULE$.usageError("v.ne(null)");
        }
        this.javaMap.put(k, v);
    }

    public void clear() {
        this.javaMap.clear();
    }

    public boolean containsKey(Object x) {
        return this.javaMap.containsKey(x);
    }

    public boolean containsValue(Object x) {
        return this.javaMap.containsValue(x);
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return CollectionConverters$.MODULE$.SetHasAsScala(this.javaMap.entrySet()).asScala();
    }

    public boolean isEmpty() {
        return this.javaMap.isEmpty();
    }

    public Set<K> keySet() {
        return CollectionConverters$.MODULE$.SetHasAsScala(this.javaMap.keySet()).asScala();
    }

    public void putAll(Map<K, V> x) {
        CollectionConverters$.MODULE$.MapHasAsScala(x).asScala().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Object k = tuple2._1();
                Object v = tuple2._2();
                this.put(k, v);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Object remove(Object x) {
        return Maybe$.MODULE$.apply(this.javaMap.remove(x));
    }

    public int size() {
        return this.javaMap.size();
    }

    public Iterable<V> values() {
        return CollectionConverters$.MODULE$.CollectionHasAsScala(this.javaMap.values()).asScala();
    }
}

