/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.functors;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.collections4.Closure;
import org.apache.commons.collections4.FunctorException;
import org.apache.commons.collections4.functors.AbstractClosureTest;
import org.apache.commons.collections4.functors.CatchAndRethrowClosure;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;

public class CatchAndRethrowClosureTest
extends AbstractClosureTest {
    private static <T> Closure<T> generateIOExceptionClosure() {
        return new CatchAndRethrowClosure<T>(){

            protected void executeAndThrow(T input) throws IOException {
                throw new IOException();
            }
        };
    }

    private static <T> Closure<T> generateNoExceptionClosure() {
        return new CatchAndRethrowClosure<T>(){

            protected void executeAndThrow(T input) {
            }
        };
    }

    private static <T> Closure<T> generateNullPointerExceptionClosure() {
        return new CatchAndRethrowClosure<T>(){

            protected void executeAndThrow(T input) {
                throw new NullPointerException();
            }
        };
    }

    @Override
    protected <T> Closure<T> generateClosure() {
        return CatchAndRethrowClosureTest.generateNoExceptionClosure();
    }

    @TestFactory
    public Collection<DynamicTest> testThrowingClosure() {
        return Arrays.asList(DynamicTest.dynamicTest((String)"Closure NoException", () -> {
            Closure closure = CatchAndRethrowClosureTest.generateNoExceptionClosure();
            closure.execute((Object)0);
        }), DynamicTest.dynamicTest((String)"Closure IOException", () -> {
            Closure closure = CatchAndRethrowClosureTest.generateIOExceptionClosure();
            FunctorException thrown = (FunctorException)Assertions.assertThrows(FunctorException.class, () -> closure.execute((Object)0));
            Assertions.assertTrue((boolean)(thrown.getCause() instanceof IOException));
        }), DynamicTest.dynamicTest((String)"Closure NullPointerException", () -> {
            Closure closure = CatchAndRethrowClosureTest.generateNullPointerExceptionClosure();
            Assertions.assertThrows(NullPointerException.class, () -> closure.execute((Object)0));
        }));
    }
}

