/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.functors;

import org.apache.commons.collections4.Predicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class AbstractPredicateTest {
    protected Object cObject;
    protected String cString;
    protected Integer cInteger;

    protected <T> void assertPredicateFalse(Predicate<T> predicate, T testObject) {
        Assertions.assertFalse((boolean)predicate.evaluate(testObject));
    }

    protected <T> void assertPredicateTrue(Predicate<T> predicate, T testObject) {
        Assertions.assertTrue((boolean)predicate.evaluate(testObject));
    }

    protected abstract Predicate<?> generatePredicate();

    @BeforeEach
    public void initializeTestObjects() throws Exception {
        this.cObject = new Object();
        this.cString = "Hello";
        this.cInteger = 6;
    }

    @Test
    public void testPredicateSanityTests() throws Exception {
        Predicate<?> predicate = this.generatePredicate();
        Assertions.assertNotNull(predicate);
    }
}

