/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.bugs;

import java.lang.reflect.Method;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.bugs.other.Jira298BeanFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Jira298TestCase
extends TestCase {
    private final Log log = LogFactory.getLog(Jira298TestCase.class);

    public static void main(String[] args) {
        TestRunner.run((Test)Jira298TestCase.suite());
    }

    public static Test suite() {
        return new TestSuite(Jira298TestCase.class);
    }

    public Jira298TestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testIssue_BEANUTILS_298_MethodUtils_getAccessibleMethod() {
        Jira298BeanFactory.IX bean = Jira298BeanFactory.createImplX();
        Object result = null;
        try {
            Method m2 = MethodUtils.getAccessibleMethod(bean.getClass(), (String)"getName", (Class[])new Class[0]);
            result = m2.invoke((Object)bean, new Object[0]);
        }
        catch (Throwable t) {
            this.log.error((Object)("Failed: " + t.getMessage()), t);
            Jira298TestCase.fail((String)("Threw exception: " + t));
        }
        Jira298TestCase.assertEquals((Object)"BaseX name value", (Object)result);
    }

    public void testIssue_BEANUTILS_298_PropertyUtils_getProperty() {
        Jira298BeanFactory.IX bean = Jira298BeanFactory.createImplX();
        Object result = null;
        try {
            result = PropertyUtils.getProperty((Object)bean, (String)"name");
        }
        catch (Throwable t) {
            this.log.error((Object)("Failed: " + t.getMessage()), t);
            Jira298TestCase.fail((String)("Threw exception: " + t));
        }
        Jira298TestCase.assertEquals((Object)"BaseX name value", (Object)result);
    }

    public void testIssue_BEANUTILS_298_PropertyUtils_setProperty() {
        Jira298BeanFactory.IX bean = Jira298BeanFactory.createImplX();
        Jira298TestCase.assertEquals((String)"BaseX name value", (String)bean.getName());
        try {
            PropertyUtils.setProperty((Object)bean, (String)"name", (Object)"new name");
        }
        catch (Throwable t) {
            this.log.error((Object)("Failed: " + t.getMessage()), t);
            Jira298TestCase.fail((String)("Threw exception: " + t));
        }
        Jira298TestCase.assertEquals((String)"new name", (String)bean.getName());
    }
}

