/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import junit.framework.TestCase;
import org.apache.commons.beanutils.BeanPropertyValueChangeClosure;
import org.apache.commons.beanutils.TestBean;

public class BeanPropertyValueChangeClosureTestCase
extends TestCase {
    private static final Integer expectedIntegerValue = 123;
    private static final Float expectedFloatValue = Float.valueOf(123.123f);
    private static final Double expectedDoubleValue = 567879.12344;
    private static final Boolean expectedBooleanValue = Boolean.TRUE;
    private static final Byte expectedByteValue = Byte.valueOf("12");

    public BeanPropertyValueChangeClosureTestCase(String name) {
        super(name);
    }

    public void testExecuteWithIndexedProperty() {
        TestBean testBean = new TestBean();
        new BeanPropertyValueChangeClosure("intIndexed[0]", (Object)expectedIntegerValue).execute((Object)testBean);
        BeanPropertyValueChangeClosureTestCase.assertTrue((expectedIntegerValue.intValue() == testBean.getIntIndexed(0) ? 1 : 0) != 0);
    }

    public void testExecuteWithInvalidPropertyName() {
        try {
            new BeanPropertyValueChangeClosure("bogusProperty", (Object)"foo").execute((Object)new TestBean());
            BeanPropertyValueChangeClosureTestCase.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testExecuteWithMappedProperty() {
        TestBean testBean = new TestBean();
        new BeanPropertyValueChangeClosure("mappedProperty(fred)", (Object)"barney").execute((Object)testBean);
        BeanPropertyValueChangeClosureTestCase.assertEquals((String)"barney", (String)testBean.getMappedProperty("fred"));
    }

    public void testExecuteWithNestedProperty() {
        TestBean testBean = new TestBean();
        new BeanPropertyValueChangeClosure("nested.stringProperty", (Object)"bar").execute((Object)testBean);
        BeanPropertyValueChangeClosureTestCase.assertEquals((String)"bar", (String)testBean.getNested().getStringProperty());
    }

    public void testExecuteWithNullInPropertyPath() {
        try {
            new BeanPropertyValueChangeClosure("anotherNested.stringProperty", (Object)"foo").execute((Object)new TestBean());
            BeanPropertyValueChangeClosureTestCase.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testExecuteWithNullInPropertyPathAngIgnoreTrue() {
        TestBean testBean = new TestBean();
        BeanPropertyValueChangeClosure closure = new BeanPropertyValueChangeClosure("anotherNested.stringProperty", (Object)"Should ignore exception", true);
        try {
            closure.execute((Object)testBean);
        }
        catch (IllegalArgumentException e) {
            BeanPropertyValueChangeClosureTestCase.fail((String)"Should have ignored the exception.");
        }
    }

    public void testExecuteWithReadOnlyProperty() {
        try {
            new BeanPropertyValueChangeClosure("readOnlyProperty", (Object)"foo").execute((Object)new TestBean());
            BeanPropertyValueChangeClosureTestCase.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testExecuteWithSimpleBooleanPropertyAndBooleanValue() {
        TestBean testBean = new TestBean();
        new BeanPropertyValueChangeClosure("booleanProperty", (Object)expectedBooleanValue).execute((Object)testBean);
        BeanPropertyValueChangeClosureTestCase.assertTrue((expectedBooleanValue.booleanValue() == testBean.getBooleanProperty() ? 1 : 0) != 0);
    }

    public void testExecuteWithSimpleBooleanPropertyAndStringValue() {
        try {
            new BeanPropertyValueChangeClosure("booleanProperty", (Object)"true").execute((Object)new TestBean());
            BeanPropertyValueChangeClosureTestCase.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testExecuteWithSimpleBytePropertyAndByteValue() {
        TestBean testBean = new TestBean();
        new BeanPropertyValueChangeClosure("byteProperty", (Object)expectedByteValue).execute((Object)testBean);
        BeanPropertyValueChangeClosureTestCase.assertTrue((expectedByteValue.byteValue() == testBean.getByteProperty() ? 1 : 0) != 0);
    }

    public void testExecuteWithSimpleBytePropertyAndStringValue() {
        try {
            new BeanPropertyValueChangeClosure("byteProperty", (Object)"foo").execute((Object)new TestBean());
            BeanPropertyValueChangeClosureTestCase.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testExecuteWithSimpleDoublePropertyAndDoubleValue() {
        TestBean testBean = new TestBean();
        new BeanPropertyValueChangeClosure("doubleProperty", (Object)expectedDoubleValue).execute((Object)testBean);
        BeanPropertyValueChangeClosureTestCase.assertTrue((expectedDoubleValue.doubleValue() == testBean.getDoubleProperty() ? 1 : 0) != 0);
    }

    public void testExecuteWithSimpleDoublePropertyAndFloatValue() {
        TestBean testBean = new TestBean();
        new BeanPropertyValueChangeClosure("doubleProperty", (Object)expectedFloatValue).execute((Object)testBean);
        BeanPropertyValueChangeClosureTestCase.assertTrue((expectedFloatValue.doubleValue() == testBean.getDoubleProperty() ? 1 : 0) != 0);
    }

    public void testExecuteWithSimpleDoublePropertyAndIntegerValue() {
        TestBean testBean = new TestBean();
        new BeanPropertyValueChangeClosure("doubleProperty", (Object)expectedIntegerValue).execute((Object)testBean);
        BeanPropertyValueChangeClosureTestCase.assertTrue((expectedIntegerValue.doubleValue() == testBean.getDoubleProperty() ? 1 : 0) != 0);
    }

    public void testExecuteWithSimpleDoublePropertyAndStringValue() {
        try {
            new BeanPropertyValueChangeClosure("doubleProperty", (Object)"123").execute((Object)new TestBean());
            BeanPropertyValueChangeClosureTestCase.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testExecuteWithSimpleFloatPropertyAndDoubleValue() {
        try {
            new BeanPropertyValueChangeClosure("floatProperty", (Object)expectedDoubleValue).execute((Object)new TestBean());
            BeanPropertyValueChangeClosureTestCase.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testExecuteWithSimpleFloatPropertyAndFloatValue() {
        TestBean testBean = new TestBean();
        new BeanPropertyValueChangeClosure("floatProperty", (Object)expectedFloatValue).execute((Object)testBean);
        BeanPropertyValueChangeClosureTestCase.assertTrue((expectedFloatValue.floatValue() == testBean.getFloatProperty() ? 1 : 0) != 0);
    }

    public void testExecuteWithSimpleFloatPropertyAndIntegerValue() {
        TestBean testBean = new TestBean();
        new BeanPropertyValueChangeClosure("floatProperty", (Object)expectedIntegerValue).execute((Object)testBean);
        BeanPropertyValueChangeClosureTestCase.assertTrue((expectedIntegerValue.floatValue() == testBean.getFloatProperty() ? 1 : 0) != 0);
    }

    public void testExecuteWithSimpleFloatPropertyAndStringValue() {
        try {
            new BeanPropertyValueChangeClosure("floatProperty", (Object)"123").execute((Object)new TestBean());
            BeanPropertyValueChangeClosureTestCase.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testExecuteWithSimpleIntPropertyAndDoubleValue() {
        try {
            new BeanPropertyValueChangeClosure("intProperty", (Object)expectedDoubleValue).execute((Object)new TestBean());
            BeanPropertyValueChangeClosureTestCase.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testExecuteWithSimpleIntPropertyAndFloatValue() {
        try {
            new BeanPropertyValueChangeClosure("intProperty", (Object)expectedFloatValue).execute((Object)new TestBean());
            BeanPropertyValueChangeClosureTestCase.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testExecuteWithSimpleIntPropertyAndIntegerValue() {
        TestBean testBean = new TestBean();
        new BeanPropertyValueChangeClosure("intProperty", (Object)expectedIntegerValue).execute((Object)testBean);
        BeanPropertyValueChangeClosureTestCase.assertTrue((expectedIntegerValue.intValue() == testBean.getIntProperty() ? 1 : 0) != 0);
    }

    public void testExecuteWithSimpleIntPropertyAndStringValue() {
        try {
            new BeanPropertyValueChangeClosure("intProperty", (Object)"123").execute((Object)new TestBean());
            BeanPropertyValueChangeClosureTestCase.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testExecuteWithSimplePrimitivePropertyAndNullValue() {
        try {
            new BeanPropertyValueChangeClosure("intProperty", null).execute((Object)new TestBean());
            BeanPropertyValueChangeClosureTestCase.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testExecuteWithSimpleStringProperty() {
        TestBean testBean = new TestBean();
        new BeanPropertyValueChangeClosure("stringProperty", (Object)"barney").execute((Object)testBean);
        BeanPropertyValueChangeClosureTestCase.assertEquals((String)"barney", (String)testBean.getStringProperty());
    }

    public void testExecuteWithWriteOnlyProperty() {
        TestBean testBean = new TestBean();
        new BeanPropertyValueChangeClosure("writeOnlyProperty", (Object)"foo").execute((Object)testBean);
        BeanPropertyValueChangeClosureTestCase.assertEquals((String)"foo", (String)testBean.getWriteOnlyPropertyValue());
    }
}

