/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.PolicyComponent;
import org.apache.ws.secpolicy.SP11Constants;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.SPConstants;
import org.apache.ws.secpolicy.model.AbstractSecurityAssertion;

public class Layout
extends AbstractSecurityAssertion {
    private String value = "Lax";

    public Layout(int version) {
        this.setVersion(version);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        if ("Lax".equals(value) || "Strict".equals(value) || "LaxTimestampFirst".equals(value) || "LaxTimestampLast".equals(value)) {
            this.value = value;
        }
    }

    public QName getName() {
        if (this.version == 2) {
            return SP12Constants.LAYOUT;
        }
        return SP11Constants.LAYOUT;
    }

    public PolicyComponent normalize() {
        throw new UnsupportedOperationException();
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String prefix = this.getName().getPrefix();
        String localName = this.getName().getLocalPart();
        String namespaceURI = this.getName().getNamespaceURI();
        Layout.writeStartElement(writer, prefix, localName, namespaceURI);
        Layout.writeStartElement(writer, SPConstants.POLICY);
        if ("Strict".equals(this.value)) {
            Layout.writeEmptyElement(writer, prefix, "Strict", namespaceURI);
        } else if ("Lax".equals(this.value)) {
            Layout.writeEmptyElement(writer, prefix, "Lax", namespaceURI);
        } else if ("LaxTimestampFirst".equals(this.value)) {
            Layout.writeEmptyElement(writer, prefix, "LaxTimestampFirst", namespaceURI);
        } else if ("LaxTimestampLast".equals(this.value)) {
            Layout.writeEmptyElement(writer, prefix, "LaxTimestampLast", namespaceURI);
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

