/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni.avro;

import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.mapred.AvroCollector;
import org.apache.avro.mapred.AvroJob;
import org.apache.avro.mapred.AvroMapper;
import org.apache.avro.mapred.AvroReducer;
import org.apache.avro.mapred.Pair;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.NullOutputFormat;
import org.apache.trevni.avro.AvroTrevniInputFormat;
import org.apache.trevni.avro.AvroTrevniOutputFormat;
import org.apache.trevni.avro.WordCountUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestWordCount {
    static final Schema STRING = Schema.create(Schema.Type.STRING);
    static final Schema LONG;
    private static long total;

    @Test
    public void runTestsInOrder() throws Exception {
        this.testOutputFormat();
        this.testInputFormat();
    }

    public void testOutputFormat() throws Exception {
        JobConf job = new JobConf();
        WordCountUtil wordCountUtil = new WordCountUtil("trevniMapredTest");
        wordCountUtil.writeLinesFile();
        AvroJob.setInputSchema(job, STRING);
        AvroJob.setOutputSchema(job, Pair.getPairSchema(STRING, LONG));
        AvroJob.setMapperClass(job, MapImpl.class);
        AvroJob.setCombinerClass(job, ReduceImpl.class);
        AvroJob.setReducerClass(job, ReduceImpl.class);
        FileInputFormat.setInputPaths(job, new Path(wordCountUtil.getDir().toString() + "/in"));
        FileOutputFormat.setOutputPath(job, new Path(wordCountUtil.getDir().toString() + "/out"));
        FileOutputFormat.setCompressOutput(job, true);
        job.setOutputFormat(AvroTrevniOutputFormat.class);
        JobClient.runJob(job);
        wordCountUtil.validateCountsFile();
    }

    public void testInputFormat() throws Exception {
        JobConf job = new JobConf();
        WordCountUtil wordCountUtil = new WordCountUtil("trevniMapredTest");
        Schema subSchema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"PairValue\",\"fields\": [ {\"name\":\"value\", \"type\":\"long\"}]}");
        AvroJob.setInputSchema(job, subSchema);
        AvroJob.setMapperClass(job, Counter.class);
        FileInputFormat.setInputPaths(job, new Path(wordCountUtil.getDir().toString() + "/out/*"));
        job.setInputFormat(AvroTrevniInputFormat.class);
        job.setNumReduceTasks(0);
        job.setOutputFormat(NullOutputFormat.class);
        total = 0L;
        JobClient.runJob(job);
        Assert.assertEquals((long)WordCountUtil.TOTAL, (long)total);
    }

    static {
        GenericData.setStringType(STRING, GenericData.StringType.String);
        LONG = Schema.create(Schema.Type.LONG);
    }

    public static class Counter
    extends AvroMapper<GenericRecord, Void> {
        @Override
        public void map(GenericRecord r, AvroCollector<Void> collector, Reporter reporter) throws IOException {
            total = total + (Long)r.get("value");
        }
    }

    public static class ReduceImpl
    extends AvroReducer<String, Long, Pair<String, Long>> {
        @Override
        public void reduce(String word, Iterable<Long> counts, AvroCollector<Pair<String, Long>> collector, Reporter reporter) throws IOException {
            long sum = 0L;
            for (long count : counts) {
                sum += count;
            }
            collector.collect(new Pair((CharSequence)word, (Long)sum));
        }
    }

    public static class MapImpl
    extends AvroMapper<String, Pair<String, Long>> {
        @Override
        public void map(String text, AvroCollector<Pair<String, Long>> collector, Reporter reporter) throws IOException {
            StringTokenizer tokens = new StringTokenizer(text);
            while (tokens.hasMoreTokens()) {
                collector.collect(new Pair((CharSequence)tokens.nextToken(), (Long)1L));
            }
        }
    }
}

